/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.pointer.ExecutableElementPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.FunctionElement;

public final class FunctionPointer
extends RootPointer
implements ExecutableElementPointer {
    private final FunctionElement function;

    FunctionPointer(FunctionElement function) {
        super(function.getType().getPointer());
        this.function = function;
    }

    public static FunctionPointer of(FunctionElement methodElement) {
        return methodElement.getOrCreatePointer(FunctionPointer::new);
    }

    @Override
    public FunctionElement getExecutableElement() {
        return this.function;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.function.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        FunctionPointer smp;
        return other instanceof FunctionPointer && this.equals(smp = (FunctionPointer)other);
    }

    public boolean equals(FunctionPointer other) {
        return super.equals(other) && this.function == other.function;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.function.getEnclosingType().getInternalName()).append('#').append(this.function.getName()).append(this.function.getDescriptor());
    }

    @Override
    public boolean isNoThrow() {
        return this.getExecutableElement().hasNoModifiersOf(0x4000000);
    }

    @Override
    public boolean isNoSafePoints() {
        return this.getExecutableElement().hasNoModifiersOf(131072);
    }

    @Override
    public boolean isNoReturn() {
        return this.getExecutableElement().hasNoModifiersOf(0x2000000);
    }

    @Override
    public boolean isNoSideEffect() {
        return this.getExecutableElement().hasNoModifiersOf(0x400000);
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

