/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.InstanceFieldElement;

public final class InstanceFieldPointer
extends Pointer {
    private final Pointer objectPointer;
    private final InstanceFieldElement fieldElement;

    public InstanceFieldPointer(Pointer objectPointer, InstanceFieldElement fieldElement) {
        super(fieldElement.getType().getPointer());
        this.objectPointer = objectPointer;
        this.fieldElement = fieldElement;
    }

    public Pointer getObjectPointer() {
        return this.objectPointer;
    }

    public InstanceFieldElement getInstanceField() {
        return this.fieldElement;
    }

    @Override
    public RootPointer getRootPointer() {
        return this.objectPointer.getRootPointer();
    }

    @Override
    public long getRootByteOffset() {
        return this.objectPointer.getRootByteOffset() + this.fieldElement.getOffset();
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return this.objectPointer.getRootMemoryIfExists();
    }

    @Override
    public String getRootSymbolIfExists() {
        return this.objectPointer.getRootSymbolIfExists();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.objectPointer.toString(b).append('.').append(this.fieldElement.getName());
    }

    @Override
    public <T, R> R accept(Pointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

