/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.CompoundType;

public final class MemberPointer
extends Pointer {
    private final Pointer structurePointer;
    private final CompoundType.Member member;

    public MemberPointer(Pointer structurePointer, CompoundType.Member member) {
        super(member.getType().getPointer());
        this.structurePointer = structurePointer;
        this.member = member;
    }

    @Override
    public CompoundType getPointeeType() {
        return (CompoundType)super.getPointeeType();
    }

    public Pointer getStructurePointer() {
        return this.structurePointer;
    }

    public CompoundType.Member getMember() {
        return this.member;
    }

    @Override
    public RootPointer getRootPointer() {
        return this.structurePointer.getRootPointer();
    }

    @Override
    public long getRootByteOffset() {
        return this.structurePointer.getRootByteOffset() + (long)this.member.getOffset();
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return this.structurePointer.getRootMemoryIfExists();
    }

    @Override
    public String getRootSymbolIfExists() {
        return this.structurePointer.getRootSymbolIfExists();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.structurePointer.toString(b).append('.').append(this.member.getName());
    }

    @Override
    public <T, R> R accept(Pointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

