/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import java.util.Iterator;
import java.util.List;
import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.ElementPointer;
import org.qbicc.pointer.InstanceFieldPointer;
import org.qbicc.pointer.MemberPointer;
import org.qbicc.pointer.OffsetPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;

public abstract class Pointer {
    private final PointerType type;

    Pointer(PointerType type) {
        this.type = type;
    }

    public long getValue() {
        throw new IllegalArgumentException("Pointer does not have a value");
    }

    public PointerType getType() {
        return this.type;
    }

    public ValueType getPointeeType() {
        return this.type.getPointeeType();
    }

    public <T extends ValueType> T getPointeeType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getPointeeType()));
    }

    public Pointer offsetInBytes(long offset, boolean array) throws IllegalArgumentException {
        long pointeeSize;
        if (offset == 0L) {
            return this;
        }
        ValueType pointeeType = this.getPointeeType();
        if (pointeeType instanceof ArrayType) {
            ArrayType at = (ArrayType)pointeeType;
            long elementSize = at.getElementSize();
            long index = offset / elementSize;
            long extra = offset % elementSize;
            return new ElementPointer(this, index).offsetInBytes(extra, array);
        }
        if (array && (pointeeSize = pointeeType.getSize()) > 0L && (offset < 0L || offset >= pointeeSize)) {
            long index = offset / pointeeSize;
            long extra = offset % pointeeSize;
            return this.offsetByElements(index).offsetInBytes(extra, false);
        }
        if (pointeeType instanceof CompoundType) {
            CompoundType ct = (CompoundType)pointeeType;
            List<CompoundType.Member> members = ct.getMembers();
            Iterator<CompoundType.Member> iterator = members.iterator();
            while (iterator.hasNext()) {
                ArrayType at2;
                ValueType valueType;
                CompoundType.Member member = iterator.next();
                int memberOffset = member.getOffset();
                if ((long)memberOffset > offset) continue;
                if (!iterator.hasNext() && (valueType = member.getType()) instanceof ArrayType && (at2 = (ArrayType)valueType).getElementCount() == 0L) {
                    return new MemberPointer(this, member).offsetInBytes(offset - (long)memberOffset, true);
                }
                if (offset >= (long)memberOffset + member.getType().getSize()) continue;
                return new MemberPointer(this, member).offsetInBytes(offset - (long)memberOffset, false);
            }
            return null;
        }
        if (pointeeType instanceof PhysicalObjectType) {
            PhysicalObjectType pot = (PhysicalObjectType)pointeeType;
            LoadedTypeDefinition def = pot.getDefinition().load();
            do {
                int fieldCount = def.getFieldCount();
                for (int i = 0; i < fieldCount; ++i) {
                    ArrayType at;
                    ValueType valueType;
                    InstanceFieldElement ife;
                    long fieldOffset;
                    FieldElement at2 = def.getField(i);
                    if (!(at2 instanceof InstanceFieldElement) || (fieldOffset = (ife = (InstanceFieldElement)at2).getOffset()) > offset) continue;
                    if (i == fieldCount - 1 && (valueType = ife.getType()) instanceof ArrayType && (at = (ArrayType)valueType).getElementCount() == 0L) {
                        return new InstanceFieldPointer(this, ife).offsetInBytes(offset - fieldOffset, true);
                    }
                    if (offset >= fieldOffset + ife.getType().getSize()) continue;
                    return new InstanceFieldPointer(this, ife).offsetInBytes(offset - fieldOffset, false);
                }
            } while ((def = def.getSuperClass()) != null);
            return null;
        }
        return null;
    }

    public Pointer offsetByElements(long count) {
        if (count == 0L) {
            return this;
        }
        return new OffsetPointer(this, count);
    }

    public abstract RootPointer getRootPointer();

    public abstract long getRootByteOffset();

    public abstract Memory getRootMemoryIfExists();

    public abstract String getRootSymbolIfExists();

    public int hashCode() {
        return this.getRootPointer().hashCode() * 19 + Long.hashCode(this.getRootByteOffset());
    }

    public final boolean equals(Object obj) {
        Pointer p;
        return obj instanceof Pointer && this.equals(p = (Pointer)obj);
    }

    public boolean equals(Pointer other) {
        return this == other || other != null && this.getRootPointer().equals(other.getRootPointer()) && this.getRootByteOffset() == other.getRootByteOffset();
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public abstract StringBuilder toString(StringBuilder var1);

    public abstract <T, R> R accept(Visitor<T, R> var1, T var2);

    public boolean isNoThrow() {
        return false;
    }

    public boolean isNoSafePoints() {
        return false;
    }

    public boolean isNoReturn() {
        return false;
    }

    public boolean isNoSideEffect() {
        return false;
    }

    public static interface Visitor<T, R>
    extends RootPointer.Visitor<T, R> {
        default public R visitAny(T t, Pointer pointer) {
            return null;
        }

        @Override
        default public R visitAny(T t, RootPointer pointer) {
            return this.visitAny(t, (Pointer)pointer);
        }

        default public R visit(T t, ElementPointer pointer) {
            return this.visitAny(t, pointer);
        }

        default public R visit(T t, InstanceFieldPointer pointer) {
            return this.visitAny(t, pointer);
        }

        default public R visit(T t, MemberPointer pointer) {
            return this.visitAny(t, pointer);
        }

        default public R visit(T t, OffsetPointer pointer) {
            return this.visitAny(t, pointer);
        }
    }
}

