/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramObject;
import org.qbicc.pointer.RootPointer;

public final class ProgramObjectPointer
extends RootPointer {
    private final ProgramObject programObject;

    ProgramObjectPointer(ProgramObject programObject) {
        super(programObject.getSymbolType());
        this.programObject = programObject;
    }

    public static ProgramObjectPointer of(ProgramObject programObject) {
        return programObject.getOrCreatePointer(ProgramObjectPointer::new);
    }

    public ProgramObject getProgramObject() {
        return this.programObject;
    }

    @Override
    public String getRootSymbolIfExists() {
        return this.programObject.getName();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.programObject.getName().hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        ProgramObjectPointer pop;
        return other instanceof ProgramObjectPointer && this.equals(pop = (ProgramObjectPointer)other);
    }

    public boolean equals(ProgramObjectPointer other) {
        return this == other || super.equals(other) && this.programObject.getName().equals(other.programObject.getName());
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.programObject.getName());
    }

    @Override
    public boolean isNoThrow() {
        Function fn;
        FunctionDeclaration fd;
        ProgramObject programObject = this.programObject;
        return programObject instanceof FunctionDeclaration && (fd = (FunctionDeclaration)programObject).isNoThrow() || (programObject = this.programObject) instanceof Function && (fn = (Function)programObject).isNoThrow();
    }

    @Override
    public boolean isNoSafePoints() {
        Function fn;
        FunctionDeclaration fd;
        ProgramObject programObject = this.programObject;
        return programObject instanceof FunctionDeclaration && (fd = (FunctionDeclaration)programObject).isNoSafePoints() || (programObject = this.programObject) instanceof Function && (fn = (Function)programObject).isNoSafePoints();
    }

    @Override
    public boolean isNoReturn() {
        Function fn;
        FunctionDeclaration fd;
        ProgramObject programObject = this.programObject;
        return programObject instanceof FunctionDeclaration && (fd = (FunctionDeclaration)programObject).isNoReturn() || (programObject = this.programObject) instanceof Function && (fn = (Function)programObject).isNoReturn();
    }

    @Override
    public boolean isNoSideEffect() {
        Function fn;
        FunctionDeclaration fd;
        ProgramObject programObject = this.programObject;
        return programObject instanceof FunctionDeclaration && (fd = (FunctionDeclaration)programObject).isNoSideEffects() || (programObject = this.programObject) instanceof Function && (fn = (Function)programObject).isNoSideEffects();
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

