/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.IntegerType;
import org.qbicc.type.Primitive;
import org.qbicc.type.ScalarType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public final class BooleanType
extends WordType {
    private final int size;
    private final int align;

    BooleanType(TypeSystem typeSystem, int size, int align) {
        super(typeSystem, BooleanType.class.hashCode() * 19 + size);
        this.size = size;
        this.align = align;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    @Override
    public int getMinBits() {
        return this.typeSystem.getByteBits();
    }

    public boolean equals(ScalarType other) {
        return other instanceof BooleanType && this.equals((BooleanType)other);
    }

    public boolean equals(BooleanType other) {
        return other == this;
    }

    @Override
    public ValueType join(ValueType other) {
        if (other instanceof BooleanType) {
            return this;
        }
        if (other instanceof IntegerType) {
            return other;
        }
        return super.join(other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append("bool");
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append("boolean");
    }

    @Override
    public Primitive asPrimitive() {
        return Primitive.BOOLEAN;
    }
}

