/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.List;
import java.util.Objects;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.DefinedTypeDefinition;

public final class ClassObjectType
extends PhysicalObjectType {
    private final DefinedTypeDefinition definition;
    private final ClassObjectType superClassType;
    private final List<InterfaceObjectType> interfaces;

    ClassObjectType(TypeSystem typeSystem, DefinedTypeDefinition definition, ClassObjectType superClassType, List<InterfaceObjectType> interfaces) {
        super(typeSystem, Objects.hash(definition));
        this.definition = definition;
        this.superClassType = superClassType;
        this.interfaces = interfaces;
    }

    @Override
    public DefinedTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassType != null;
    }

    @Override
    public ClassObjectType getSuperClassType() {
        return this.superClassType;
    }

    public List<InterfaceObjectType> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public long getSize() {
        throw new IllegalStateException("Object layout has not yet taken place");
    }

    @Override
    public boolean isSubtypeOf(ObjectType other) {
        return this == other || other instanceof ClassObjectType && this.isSubtypeOf((ClassObjectType)other) || other instanceof InterfaceObjectType && this.isSubtypeOf((InterfaceObjectType)other);
    }

    public boolean isSubtypeOf(ClassObjectType other) {
        return this == other || other.superClassType == null || this.superClassType != null && this.superClassType.isSubtypeOf(other);
    }

    public boolean isSubtypeOf(InterfaceObjectType other) {
        for (InterfaceObjectType interface_ : this.interfaces) {
            if (!interface_.isSubtypeOf(other)) continue;
            return true;
        }
        return this.superClassType != null && this.superClassType.isSubtypeOf(other);
    }

    @Override
    public ObjectType getCommonSupertype(ObjectType other) {
        if (other instanceof ClassObjectType) {
            return this.getCommonSupertype((ClassObjectType)other);
        }
        if (other instanceof InterfaceObjectType) {
            return this.isSubtypeOf(other) ? other : this.getRootType();
        }
        assert (other instanceof ArrayObjectType);
        return this.getRootType();
    }

    private ClassObjectType getRootType() {
        return this.superClassType != null ? this.superClassType.getRootType() : this;
    }

    public ClassObjectType getCommonSupertype(ClassObjectType other) {
        return this.isSubtypeOf(other) ? other : (this.isSupertypeOf(other) ? this : other.getSuperClassType().getCommonSupertype(this));
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append("class").append('(').append(this.definition.getInternalName()).append(')');
    }

    @Override
    public final boolean equals(ObjectType other) {
        return other instanceof ClassObjectType && this.equals((ClassObjectType)other);
    }

    public boolean equals(ClassObjectType other) {
        return super.equals(other) && this.definition == other.definition;
    }
}

