/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.List;
import org.qbicc.type.InvokableType;
import org.qbicc.type.MethodType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;

public final class InstanceMethodType
extends MethodType {
    private final ValueType receiverType;

    InstanceMethodType(TypeSystem typeSystem, ValueType receiverType, ValueType returnType, List<ValueType> paramTypes) {
        super(typeSystem, receiverType.hashCode(), returnType, paramTypes);
        this.receiverType = receiverType;
    }

    public ValueType getReceiverType() {
        return this.receiverType;
    }

    public InstanceMethodType withReceiverType(ValueType receiverType) {
        return this.getTypeSystem().getInstanceMethodType(receiverType, this.getReturnType(), this.getParameterTypes());
    }

    @Override
    public InstanceMethodType withReturnType(ValueType returnType) {
        return this.getTypeSystem().getInstanceMethodType(this.getReceiverType(), returnType, this.getParameterTypes());
    }

    @Override
    public InstanceMethodType withParameterTypes(List<ValueType> parameterTypes) {
        return this.getTypeSystem().getInstanceMethodType(this.getReceiverType(), this.getReturnType(), parameterTypes);
    }

    @Override
    public InstanceMethodType withFirstParameterType(ValueType type) {
        return (InstanceMethodType)super.withFirstParameterType(type);
    }

    @Override
    public InstanceMethodType trimLastParameter() throws IndexOutOfBoundsException {
        return (InstanceMethodType)super.trimLastParameter();
    }

    @Override
    public boolean equals(InvokableType other) {
        InstanceMethodType smt;
        return other instanceof InstanceMethodType && this.equals(smt = (InstanceMethodType)other);
    }

    public boolean equals(InstanceMethodType other) {
        return super.equals(other) && this.receiverType.equals(other.receiverType);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append("instance method ").append(this.receiverType);
        return super.toString(b);
    }
}

