/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.DefinedTypeDefinition;

public final class InterfaceObjectType
extends ObjectType {
    private final DefinedTypeDefinition definition;
    private final List<InterfaceObjectType> interfaces;

    InterfaceObjectType(TypeSystem typeSystem, DefinedTypeDefinition definition, List<InterfaceObjectType> interfaces) {
        super(typeSystem, Objects.hash(definition));
        this.definition = definition;
        this.interfaces = interfaces;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public int getAlign() {
        return 0;
    }

    @Override
    public DefinedTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    ReferenceType createReferenceType() {
        return this.typeSystem.createReference(this.getRootType(), Set.of(this));
    }

    @Override
    public boolean hasSuperClass() {
        return false;
    }

    @Override
    public boolean isSubtypeOf(ObjectType other) {
        return this == other || other instanceof InterfaceObjectType && this.isSubtypeOf((InterfaceObjectType)other) || other instanceof ClassObjectType && this.isSubtypeOf((ClassObjectType)other);
    }

    public boolean isSubtypeOf(InterfaceObjectType other) {
        if (this == other) {
            return true;
        }
        for (InterfaceObjectType interface_ : this.interfaces) {
            if (!interface_.isSubtypeOf(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtypeOf(ClassObjectType other) {
        return other.getSuperClassType() == null;
    }

    @Override
    public ObjectType getCommonSupertype(ObjectType other) {
        if (other instanceof ClassObjectType) {
            return other.getCommonSupertype(this);
        }
        if (other instanceof InterfaceObjectType) {
            if (this.isSubtypeOf(other)) {
                return other;
            }
            if (this.isSupertypeOf(other)) {
                return this;
            }
            return this.getRootType();
        }
        assert (other instanceof ArrayObjectType);
        return this.getRootType();
    }

    private PhysicalObjectType getRootType() {
        return (PhysicalObjectType)this.definition.getContext().findDefinedType("java/lang/Object").load().getObjectType();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append("interface").append('(').append(this.definition.getInternalName()).append(')');
    }

    @Override
    public final boolean equals(ObjectType other) {
        return other instanceof InterfaceObjectType && this.equals((InterfaceObjectType)other);
    }

    public boolean equals(InterfaceObjectType other) {
        return super.equals(other) && this.definition == other.definition;
    }
}

