/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Base64;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;

public abstract class ObjectType
extends ValueType {
    private static final VarHandle referenceTypeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "referenceType", VarHandle.class, ObjectType.class, ReferenceType.class);
    private static final VarHandle refArrayTypeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "refArrayType", VarHandle.class, ObjectType.class, ReferenceArrayObjectType.class);
    private volatile ReferenceType referenceType;
    private volatile ReferenceArrayObjectType refArrayType;
    static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    ObjectType(TypeSystem typeSystem, int hashCode) {
        super(typeSystem, hashCode);
    }

    public DefinedTypeDefinition getDefinition() {
        throw new IllegalArgumentException("Type " + this + " is not a defined type");
    }

    public final ReferenceType getReference() {
        ReferenceType referenceType = this.referenceType;
        if (referenceType != null) {
            return referenceType;
        }
        ReferenceType newReferenceType = this.createReferenceType();
        while (!referenceTypeHandle.compareAndSet(this, null, newReferenceType)) {
            referenceType = this.referenceType;
            if (referenceType == null) continue;
            return referenceType;
        }
        return newReferenceType;
    }

    public final ReferenceArrayObjectType getReferenceArrayObject() {
        ReferenceArrayObjectType refArrayType = this.refArrayType;
        if (refArrayType != null) {
            return refArrayType;
        }
        ReferenceArrayObjectType newReferenceArrayObjectType = this.typeSystem.createReferenceArrayObject(this);
        while (!refArrayTypeHandle.compareAndSet(this, null, newReferenceArrayObjectType)) {
            refArrayType = this.refArrayType;
            if (refArrayType == null) continue;
            return refArrayType;
        }
        return newReferenceArrayObjectType;
    }

    @Override
    public ValueType getTypeAtOffset(long offset) {
        return this.getTypeSystem().getVoidType();
    }

    abstract ReferenceType createReferenceType();

    public abstract boolean hasSuperClass();

    public ClassObjectType getSuperClassType() {
        return null;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    public abstract boolean isSubtypeOf(ObjectType var1);

    public abstract ObjectType getCommonSupertype(ObjectType var1);

    public boolean isSupertypeOf(ObjectType other) {
        return other.isSubtypeOf(this);
    }

    @Override
    public final boolean equals(ValueType other) {
        return other instanceof ObjectType && this.equals((ObjectType)other);
    }

    public boolean equals(ObjectType other) {
        return super.equals(other);
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        DefinedTypeDefinition definition = this.getDefinition();
        b.append(definition.getInternalName().replace('/', '.'));
        if (definition.isHidden()) {
            b.append('/').append(ENCODER.encodeToString(definition.getDigest())).append('.').append(definition.getHiddenClassIndex());
        }
        return b;
    }
}

