/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.NullableType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;

public final class PointerType
extends NullableType {
    private final ValueType pointeeType;
    private final boolean restrict;
    private final boolean constPointee;
    private final PointerType asRestrict;
    private final PointerType withConstPointee;
    private final int size;
    private final PointerType asWide;

    PointerType(TypeSystem typeSystem, ValueType pointeeType, boolean restrict, boolean constPointee, int size) {
        super(typeSystem, pointeeType.hashCode() * 19 + Boolean.hashCode(restrict));
        this.pointeeType = pointeeType;
        this.restrict = restrict;
        this.constPointee = constPointee;
        this.asRestrict = restrict ? this : new PointerType(typeSystem, pointeeType, true, constPointee, size);
        this.withConstPointee = constPointee ? this : new PointerType(typeSystem, pointeeType, restrict, true, size);
        this.asWide = size == 8 ? this : new PointerType(typeSystem, pointeeType, restrict, constPointee, 8);
        this.size = size;
    }

    public ValueType getPointeeType() {
        return this.pointeeType;
    }

    public <T extends ValueType> T getPointeeType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getPointeeType()));
    }

    @Override
    public int getAlign() {
        return this.typeSystem.getPointerAlignment();
    }

    public PointerType asRestrict() {
        return this.asRestrict;
    }

    public PointerType withConstPointee() {
        return this.withConstPointee;
    }

    public PointerType withQualifiersFrom(PointerType otherPointerType) {
        PointerType pointerType = this;
        if (otherPointerType.isRestrict()) {
            pointerType = pointerType.asRestrict();
        }
        if (otherPointerType.isConstPointee()) {
            pointerType = pointerType.withConstPointee();
        }
        return pointerType;
    }

    public PointerType asWide() {
        return this.asWide;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getMinBits() {
        return (int)this.getSize() * this.typeSystem.getByteBits();
    }

    public SignedIntegerType getSameSizedSignedInteger() {
        return switch (this.size) {
            case 4 -> this.typeSystem.getSignedInteger32Type();
            case 8 -> this.typeSystem.getSignedInteger64Type();
            default -> throw new IllegalStateException();
        };
    }

    public UnsignedIntegerType getSameSizedUnsignedInteger() {
        return switch (this.size) {
            case 4 -> this.typeSystem.getUnsignedInteger32Type();
            case 8 -> this.typeSystem.getUnsignedInteger64Type();
            default -> throw new IllegalStateException();
        };
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public boolean isConstPointee() {
        return this.constPointee;
    }

    @Override
    public boolean equals(ValueType other) {
        return other instanceof PointerType && this.equals((PointerType)other);
    }

    public boolean equals(PointerType other) {
        return other == this || super.equals(other) && this.restrict == other.restrict && this.pointeeType.equals(other.pointeeType);
    }

    @Override
    public ValueType join(ValueType other) {
        return other instanceof PointerType ? this.join((PointerType)other) : super.join(other);
    }

    public ValueType join(PointerType other) {
        boolean constPointee;
        ValueType pointeeType = this.getPointeeType().join(other.getPointeeType());
        PointerType pointerType = pointeeType.getPointer();
        boolean restrict = this.restrict || other.restrict;
        boolean bl = constPointee = this.constPointee || other.constPointee;
        if (restrict) {
            pointerType = pointerType.asRestrict();
        }
        if (constPointee) {
            pointerType = pointerType.withConstPointee();
        }
        return pointerType;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        if (this.restrict) {
            b.append("restrict ");
        }
        if (this.size == 8 && this.typeSystem.getPointerSize() < 8) {
            b.append("wide ");
        }
        b.append("pointer to ");
        if (this.constPointee) {
            b.append("const ");
        }
        this.pointeeType.toString(b);
        return b;
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.pointeeType.toFriendlyString(b).append('*');
    }

    @Override
    public PointerType getConstraintType() {
        return this;
    }
}

