/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.function.Consumer;
import org.qbicc.type.ValueType;
import org.qbicc.type.descriptor.BaseTypeDescriptor;

public enum Primitive {
    VOID("void"),
    BOOLEAN("boolean"),
    BYTE("byte"),
    SHORT("short"),
    CHAR("char"),
    INT("int"),
    FLOAT("float"),
    LONG("long"),
    DOUBLE("double");

    private final String name;
    private volatile int typeId;
    private volatile ValueType type;

    private Primitive(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public ValueType getType() {
        return this.type;
    }

    public <T extends ValueType> T getType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getType()));
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public static void forEach(Consumer<Primitive> function) {
        for (Primitive type : Primitive.values()) {
            function.accept(type);
        }
    }

    public static Primitive getPrimitiveFor(BaseTypeDescriptor btd) {
        return Primitive.getPrimitiveFor(btd.getShortName());
    }

    public static Primitive getPrimitiveFor(char shortName) {
        switch (shortName) {
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'J': {
                return LONG;
            }
            case 'C': {
                return CHAR;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'V': {
                return VOID;
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + shortName);
    }

    public static Primitive getPrimitiveFor(String typeName) {
        return switch (typeName) {
            case "byte" -> BYTE;
            case "short" -> SHORT;
            case "int" -> INT;
            case "long" -> LONG;
            case "char" -> CHAR;
            case "float" -> FLOAT;
            case "double" -> DOUBLE;
            case "boolean" -> BOOLEAN;
            case "void" -> VOID;
            default -> throw new IllegalStateException("Unexpected primitive type: " + typeName);
        };
    }
}

