/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.type.IntegerType;
import org.qbicc.type.Primitive;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;

public final class SignedIntegerType
extends IntegerType {
    SignedIntegerType(TypeSystem typeSystem, int size, int align, int minBits) {
        super(typeSystem, SignedIntegerType.class.hashCode(), size, align, minBits);
    }

    @Override
    public boolean equals(IntegerType other) {
        return other instanceof SignedIntegerType && this.getMinBits() == other.getMinBits() && this.typeSystem == other.typeSystem;
    }

    @Override
    public SignedIntegerType getConstraintType() {
        return this;
    }

    @Override
    public SignedIntegerType asSigned() {
        return this;
    }

    @Override
    public UnsignedIntegerType asUnsigned() {
        switch (this.minBits) {
            case 8: {
                return this.typeSystem.getUnsignedInteger8Type();
            }
            case 16: {
                return this.typeSystem.getUnsignedInteger16Type();
            }
            case 32: {
                return this.typeSystem.getUnsignedInteger32Type();
            }
            case 64: {
                return this.typeSystem.getUnsignedInteger64Type();
            }
        }
        throw Assert.impossibleSwitchCase((int)this.minBits);
    }

    @Override
    public SignedIntegerType asSized(int minBits) {
        switch (minBits) {
            case 8: {
                return this.typeSystem.getSignedInteger8Type();
            }
            case 16: {
                return this.typeSystem.getSignedInteger16Type();
            }
            case 32: {
                return this.typeSystem.getSignedInteger32Type();
            }
            case 64: {
                return this.typeSystem.getSignedInteger64Type();
            }
        }
        throw Assert.impossibleSwitchCase((int)minBits);
    }

    @Override
    public long truncateValue(long value) {
        switch (this.minBits) {
            case 8: {
                return (byte)value;
            }
            case 16: {
                return (short)value;
            }
            case 32: {
                return (int)value;
            }
            case 64: {
                return value;
            }
        }
        throw Assert.impossibleSwitchCase((int)this.minBits);
    }

    @Override
    public long getMaxValue() {
        return (1L << this.minBits - 1) - 1L;
    }

    @Override
    public long getMinValue() {
        return this.getMaxValue() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public double getUpperInclusiveBound() {
        return Math.scalb(1.0, this.minBits - 1) - 1.0;
    }

    @Override
    public double getLowerInclusiveBound() {
        return -Math.scalb(1.0, this.minBits - 1);
    }

    @Override
    public ValueType join(ValueType other) {
        if (other instanceof SignedIntegerType) {
            return this.join((SignedIntegerType)other);
        }
        return super.join(other);
    }

    public SignedIntegerType join(SignedIntegerType other) {
        return this.minBits < other.minBits ? other : this;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append("s").append(this.minBits);
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append(switch (this.minBits) {
            case 8 -> "byte";
            case 16 -> "short";
            case 32 -> "int";
            case 64 -> "long";
            case 128 -> "s128";
            default -> throw Assert.impossibleSwitchCase((int)this.minBits);
        });
    }

    @Override
    public String toString(IntegerLiteral literal) {
        return this.toString(new StringBuilder()).append(' ').append(literal.longValue()).toString();
    }

    @Override
    public Primitive asPrimitive() {
        switch (this.minBits) {
            case 8: {
                return Primitive.BYTE;
            }
            case 16: {
                return Primitive.SHORT;
            }
            case 32: {
                return Primitive.INT;
            }
            case 64: {
                return Primitive.LONG;
            }
        }
        throw Assert.impossibleSwitchCase((int)this.minBits);
    }
}

