/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.Objects;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public final class TypeType
extends WordType {
    private final ValueType upperBound;

    TypeType(TypeSystem typeSystem, ValueType upperBound) {
        super(typeSystem, Objects.hash(TypeType.class, upperBound));
        this.upperBound = upperBound;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public long getSize() {
        return this.typeSystem.getTypeIdSize();
    }

    @Override
    public int getAlign() {
        return this.typeSystem.getTypeIdAlignment();
    }

    public ValueType getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean equals(ValueType other) {
        return other instanceof TypeType && this.equals((TypeType)other);
    }

    public boolean equals(TypeType other) {
        return super.equals(other) && this.upperBound.equals(other.upperBound);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.upperBound.toString(b.append("typeof").append('.'));
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.upperBound.toFriendlyString(b.append("typeof").append('(')).append(')');
    }

    @Override
    public int getMinBits() {
        return this.typeSystem.getTypeIdSize() * this.typeSystem.getByteBits();
    }
}

