/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static long alignUp(long value, int alignment) {
        TypeUtil.checkAlignmentParameter("alignment", alignment);
        int mask = alignment - 1;
        return value + (long)mask & (long)(~mask);
    }

    public static void checkAlignmentParameter(String name, int value) {
        Assert.checkMinimumParameter((String)name, (int)1, (int)value);
        if (Integer.bitCount(value) != 1) {
            throw new IllegalArgumentException("Invalid alignment");
        }
    }

    public static int nextPowerOfTwoUnsigned(int val) {
        if (val == 0) {
            throw new IllegalArgumentException("Value must be greater than zero");
        }
        int hob = Integer.highestOneBit(val);
        if (val == hob) {
            return val;
        }
        if (hob == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Next power of two is out of range");
        }
        return hob << 1;
    }

    public static long nextPowerOfTwoUnsigned(long val) {
        if (val == 0L) {
            throw new IllegalArgumentException("Value must be greater than zero");
        }
        long hob = Long.highestOneBit(val);
        if (val == hob) {
            return val;
        }
        if (hob == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Next power of two is out of range");
        }
        return hob << 1;
    }
}

