/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.type.IntegerType;
import org.qbicc.type.Primitive;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;

public final class UnsignedIntegerType
extends IntegerType {
    UnsignedIntegerType(TypeSystem typeSystem, int size, int align, int minBits) {
        super(typeSystem, UnsignedIntegerType.class.hashCode(), size, align, minBits);
    }

    @Override
    public boolean equals(IntegerType other) {
        return other instanceof UnsignedIntegerType && this.getMinBits() == other.getMinBits() && this.typeSystem == other.typeSystem;
    }

    @Override
    public UnsignedIntegerType getConstraintType() {
        return this;
    }

    @Override
    public UnsignedIntegerType asUnsigned() {
        return this;
    }

    @Override
    public UnsignedIntegerType asSized(int minBits) {
        switch (minBits) {
            case 8: {
                return this.typeSystem.getUnsignedInteger8Type();
            }
            case 16: {
                return this.typeSystem.getUnsignedInteger16Type();
            }
            case 32: {
                return this.typeSystem.getUnsignedInteger32Type();
            }
            case 64: {
                return this.typeSystem.getUnsignedInteger64Type();
            }
        }
        throw Assert.impossibleSwitchCase((int)minBits);
    }

    @Override
    public long truncateValue(long value) {
        switch (this.minBits) {
            case 8: {
                return value & 0xFFL;
            }
            case 16: {
                return value & 0xFFFFL;
            }
            case 32: {
                return value & 0xFFFFFFFFL;
            }
            case 64: {
                return value;
            }
        }
        throw Assert.impossibleSwitchCase((int)this.minBits);
    }

    @Override
    public long getMaxValue() {
        int numBits = this.minBits - 1;
        return 1L << numBits | (1L << numBits) - 1L;
    }

    @Override
    public long getMinValue() {
        return 0L;
    }

    @Override
    public double getUpperInclusiveBound() {
        return Math.scalb(1.0, this.minBits) - 1.0;
    }

    @Override
    public double getLowerInclusiveBound() {
        return 0.0;
    }

    @Override
    public ValueType join(ValueType other) {
        if (other instanceof UnsignedIntegerType) {
            return this.join((UnsignedIntegerType)other);
        }
        return super.join(other);
    }

    public UnsignedIntegerType join(UnsignedIntegerType other) {
        return this.minBits < other.minBits ? other : this;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append("u").append(this.minBits);
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append(switch (this.minBits) {
            case 8 -> "u8";
            case 16 -> "char";
            case 32 -> "u32";
            case 64 -> "u64";
            case 128 -> "u128";
            default -> throw Assert.impossibleSwitchCase((int)this.minBits);
        });
    }

    @Override
    public String toString(IntegerLiteral literal) {
        return this.toString(new StringBuilder()).append(' ').append(Long.toUnsignedString(literal.longValue())).toString();
    }

    @Override
    public SignedIntegerType asSigned() {
        switch (this.minBits) {
            case 8: {
                return this.typeSystem.getSignedInteger8Type();
            }
            case 16: {
                return this.typeSystem.getSignedInteger16Type();
            }
            case 32: {
                return this.typeSystem.getSignedInteger32Type();
            }
            case 64: {
                return this.typeSystem.getSignedInteger64Type();
            }
        }
        throw Assert.impossibleSwitchCase((int)this.minBits);
    }

    @Override
    public Primitive asPrimitive() {
        if (this.minBits == 16) {
            return Primitive.CHAR;
        }
        throw new UnsupportedOperationException();
    }
}

