/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import io.smallrye.common.constraint.Assert;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.BooleanAnnotationValue;
import org.qbicc.type.annotation.ByteAnnotationValue;
import org.qbicc.type.annotation.CharAnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.annotation.DoubleAnnotationValue;
import org.qbicc.type.annotation.EnumConstantAnnotationValue;
import org.qbicc.type.annotation.FloatAnnotationValue;
import org.qbicc.type.annotation.IntAnnotationValue;
import org.qbicc.type.annotation.LongAnnotationValue;
import org.qbicc.type.annotation.ShortAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.classfile.ClassFile;
import org.qbicc.type.definition.classfile.ConstantPool;
import org.qbicc.type.definition.classfile.InvalidAnnotationValueException;
import org.qbicc.type.descriptor.TypeDescriptor;

public abstract class AnnotationValue {
    private static final AnnotationValue[] NO_VALUES = new AnnotationValue[0];

    AnnotationValue() {
    }

    public static ArrayAnnotationValue array(AnnotationValue ... values) {
        return new ArrayAnnotationValue((AnnotationValue[])((AnnotationValue[])Assert.checkNotNullParam((String)"values", (Object)values)).clone());
    }

    public static ArrayAnnotationValue array(Collection<AnnotationValue> values) {
        return new ArrayAnnotationValue(((Collection)Assert.checkNotNullParam((String)"values", values)).toArray(NO_VALUES));
    }

    public abstract void deparseValueTo(ByteArrayOutputStream var1, ConstantPool var2);

    public abstract Kind getKind();

    static int next(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    static int nextShort(ByteBuffer buf) {
        return buf.getShort() & 0xFFFF;
    }

    static int peek(ByteBuffer buf) {
        return buf.get(buf.position()) & 0xFF;
    }

    static void expect(ByteBuffer buf, int val) {
        if (AnnotationValue.next(buf) != val) {
            throw AnnotationValue.parseError();
        }
    }

    static int codePoint(ByteBuffer buf) {
        int a = AnnotationValue.next(buf);
        if (a < 128) {
            return a;
        }
        if (a < 192) {
            throw AnnotationValue.parseError();
        }
        if (a < 224) {
            int b = AnnotationValue.next(buf);
            if (b < 128 || 191 < b) {
                throw AnnotationValue.parseError();
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = AnnotationValue.next(buf);
            if (b < 128 || 191 < b) {
                throw AnnotationValue.parseError();
            }
            int c = AnnotationValue.next(buf);
            if (c < 128 || 191 < c) {
                throw AnnotationValue.parseError();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw AnnotationValue.parseError();
    }

    static IllegalArgumentException parseError() {
        return new IllegalArgumentException("Invalid generic signature string");
    }

    public static AnnotationValue parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        switch (AnnotationValue.next(buf)) {
            case 66: {
                return ByteAnnotationValue.of(classFile.getIntConstant(AnnotationValue.nextShort(buf)));
            }
            case 67: {
                return CharAnnotationValue.of(classFile.getIntConstant(AnnotationValue.nextShort(buf)));
            }
            case 68: {
                return DoubleAnnotationValue.of(classFile.getDoubleConstant(AnnotationValue.nextShort(buf)));
            }
            case 70: {
                return FloatAnnotationValue.of(classFile.getFloatConstant(AnnotationValue.nextShort(buf)));
            }
            case 73: {
                return IntAnnotationValue.of(classFile.getIntConstant(AnnotationValue.nextShort(buf)));
            }
            case 74: {
                return LongAnnotationValue.of(classFile.getLongConstant(AnnotationValue.nextShort(buf)));
            }
            case 83: {
                return ShortAnnotationValue.of(classFile.getIntConstant(AnnotationValue.nextShort(buf)));
            }
            case 90: {
                return BooleanAnnotationValue.of(classFile.getIntConstant(AnnotationValue.nextShort(buf)) != 0);
            }
            case 115: {
                return StringAnnotationValue.of(classFile.getUtf8Constant(AnnotationValue.nextShort(buf)));
            }
            case 101: {
                return EnumConstantAnnotationValue.of(classFile.getUtf8Constant(AnnotationValue.nextShort(buf)), classFile.getUtf8Constant(AnnotationValue.nextShort(buf)));
            }
            case 99: {
                return ClassAnnotationValue.of((TypeDescriptor)classFile.getDescriptorConstant(AnnotationValue.nextShort(buf)));
            }
            case 64: {
                return Annotation.parse(classFile, classContext, buf);
            }
            case 91: {
                int count = AnnotationValue.nextShort(buf);
                AnnotationValue[] array = new AnnotationValue[count];
                for (int j = 0; j < count; ++j) {
                    array[j] = AnnotationValue.parse(classFile, classContext, buf);
                }
                return AnnotationValue.array(array);
            }
        }
        throw new InvalidAnnotationValueException("Invalid annotation value tag");
    }

    public static enum Kind {
        BYTE,
        CHAR,
        DOUBLE,
        FLOAT,
        INT,
        LONG,
        SHORT,
        BOOLEAN,
        STRING,
        ENUM,
        CLASS,
        ANNOTATION,
        ARRAY;

    }
}

