/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.PrimitiveAnnotationValue;

public final class BooleanAnnotationValue
extends PrimitiveAnnotationValue {
    private final boolean value;
    public static final BooleanAnnotationValue FALSE = new BooleanAnnotationValue(false);
    public static final BooleanAnnotationValue TRUE = new BooleanAnnotationValue(true);

    private BooleanAnnotationValue(boolean value) {
        this.value = value;
    }

    public static BooleanAnnotationValue of(boolean val) {
        return val ? TRUE : FALSE;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public char charValue() {
        return this.value ? (char)'1' : '0';
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.BOOLEAN;
    }
}

