/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import io.smallrye.common.constraint.Assert;
import java.io.ByteArrayOutputStream;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.classfile.ConstantPool;

public class EnumConstantAnnotationValue
extends AnnotationValue {
    private final String typeName;
    private final String valueName;

    EnumConstantAnnotationValue(String typeName, String valueName) {
        this.typeName = typeName;
        this.valueName = valueName;
    }

    public static EnumConstantAnnotationValue of(String typeName, String valueName) {
        return new EnumConstantAnnotationValue((String)Assert.checkNotNullParam((String)"typeName", (Object)typeName), (String)Assert.checkNotNullParam((String)"valueName", (Object)valueName));
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getValueName() {
        return this.valueName;
    }

    @Override
    public void deparseValueTo(ByteArrayOutputStream os, ConstantPool cp) {
        os.write(101);
        Annotation.writeShort(os, cp.getOrAddUtf8Constant(this.typeName));
        Annotation.writeShort(os, cp.getOrAddUtf8Constant(this.valueName));
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.ENUM;
    }
}

