/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.PrimitiveAnnotationValue;

public final class FloatAnnotationValue
extends PrimitiveAnnotationValue {
    private final float value;

    FloatAnnotationValue(float value) {
        this.value = value;
    }

    public static FloatAnnotationValue of(float value) {
        return new FloatAnnotationValue(value);
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0f;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.FLOAT;
    }
}

