/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import java.io.ByteArrayOutputStream;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.classfile.ConstantPool;

public abstract class PrimitiveAnnotationValue
extends AnnotationValue {
    PrimitiveAnnotationValue() {
    }

    public abstract boolean booleanValue();

    public abstract byte byteValue();

    public abstract short shortValue();

    public abstract int intValue();

    public abstract long longValue();

    public abstract char charValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    @Override
    public void deparseValueTo(ByteArrayOutputStream os, ConstantPool cp) {
        os.write(switch (this.getKind()) {
            case AnnotationValue.Kind.BYTE -> 66;
            case AnnotationValue.Kind.CHAR -> 67;
            case AnnotationValue.Kind.DOUBLE -> 68;
            case AnnotationValue.Kind.FLOAT -> 70;
            case AnnotationValue.Kind.INT -> 73;
            case AnnotationValue.Kind.LONG -> 74;
            case AnnotationValue.Kind.SHORT -> 83;
            case AnnotationValue.Kind.BOOLEAN -> 90;
            default -> throw new IllegalStateException();
        });
        Annotation.writeShort(os, switch (this.getKind()) {
            case AnnotationValue.Kind.LONG -> cp.getOrAddLongConstant(this.longValue());
            case AnnotationValue.Kind.FLOAT -> cp.getOrAddIntConstant(Float.floatToRawIntBits(this.floatValue()));
            case AnnotationValue.Kind.DOUBLE -> cp.getOrAddLongConstant(Double.doubleToRawLongBits(this.doubleValue()));
            default -> cp.getOrAddIntConstant(this.intValue());
        });
    }
}

