/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.type.TypeAnnotation;
import org.qbicc.type.annotation.type.TypePathKind;
import org.qbicc.type.definition.classfile.ClassFile;

public final class TypeAnnotationList
implements Iterable<TypeAnnotation> {
    final TypePathKind pathKind;
    final int idx;
    final List<TypeAnnotationList> nested;
    final List<TypeAnnotation> annotations;
    private static final TypeAnnotationList EMPTY = new TypeAnnotationList(null, 0, List.of(), List.of());
    private static final Predicate<TypeAnnotation> TOP = a -> true;

    TypeAnnotationList(TypePathKind pathKind, int idx, List<TypeAnnotationList> nested, List<TypeAnnotation> annotations) {
        this.pathKind = pathKind;
        this.idx = idx;
        this.nested = nested;
        this.annotations = annotations;
    }

    public TypeAnnotationList inArray() {
        for (TypeAnnotationList item : this.nested) {
            if (item.pathKind != TypePathKind.ARRAY) continue;
            return item;
        }
        return TypeAnnotationList.empty();
    }

    public TypeAnnotationList inNestedType() {
        for (TypeAnnotationList item : this.nested) {
            if (item.pathKind != TypePathKind.NESTED) continue;
            return item;
        }
        return TypeAnnotationList.empty();
    }

    public TypeAnnotationList onWildCardBound() {
        for (TypeAnnotationList item : this.nested) {
            if (item.pathKind != TypePathKind.WILDCARD_BOUND) continue;
            return item;
        }
        return TypeAnnotationList.empty();
    }

    public TypeAnnotationList onTypeArgument(int idx) {
        for (TypeAnnotationList item : this.nested) {
            if (item.pathKind != TypePathKind.ARRAY || item.idx != idx) continue;
            return item;
        }
        return TypeAnnotationList.empty();
    }

    @Override
    public Iterator<TypeAnnotation> iterator() {
        return this.annotations.iterator();
    }

    public static TypeAnnotationList empty() {
        return EMPTY;
    }

    public static TypeAnnotationList parse(ClassFile classFile, ClassContext ctxt, ByteBuffer buf) {
        int cnt = TypeAnnotation.nextShort(buf);
        if (cnt == 0) {
            return TypeAnnotationList.empty();
        }
        TypeAnnotation[] array = new TypeAnnotation[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = TypeAnnotation.parse(classFile, ctxt, buf);
        }
        return TypeAnnotationList.build(List.of(array));
    }

    public static TypeAnnotationList build(List<TypeAnnotation> rawAnnotationList) {
        if (rawAnnotationList.isEmpty()) {
            return TypeAnnotationList.empty();
        }
        TypeAnnotationList rootList = new TypeAnnotationList(null, 0, new ArrayList<TypeAnnotationList>(3), new ArrayList<TypeAnnotation>(3));
        for (TypeAnnotation typeAnnotation : rawAnnotationList) {
            TypeAnnotationList.findOrCreateNested((TypeAnnotationList)rootList, (TypeAnnotation)typeAnnotation, (int)0).annotations.add(typeAnnotation);
        }
        return rootList;
    }

    private static TypeAnnotationList findOrCreateNested(TypeAnnotationList rootList, TypeAnnotation annotation, int idx) {
        if (idx == annotation.getPathLength()) {
            return rootList;
        }
        List<TypeAnnotationList> nested = rootList.nested;
        TypePathKind searchKind = annotation.getPathKind(idx);
        int searchIdx = annotation.getPathArgumentIndex(idx);
        for (TypeAnnotationList list : nested) {
            if (list.pathKind != searchKind || list.idx != searchIdx) continue;
            return TypeAnnotationList.findOrCreateNested(list, annotation, idx + 1);
        }
        TypeAnnotationList newList = TypeAnnotationList.findOrCreateNested(new TypeAnnotationList(searchKind, searchIdx, new ArrayList<TypeAnnotationList>(3), new ArrayList<TypeAnnotation>(3)), annotation, idx + 1);
        rootList.nested.add(newList);
        return newList;
    }
}

