/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import java.nio.ByteBuffer;

public final class ClassFileUtil {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_Dynamic = 17;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final int CONSTANT_Module = 19;
    public static final int CONSTANT_Package = 20;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_OPEN = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MODULE = 32768;
    public static final int ACC_MANDATED = 32768;
    public static final int V9 = 53;

    private ClassFileUtil() {
    }

    public static String getClassName(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        if (classFile.get(cpOffsets[cpEntryNumber]) != 7) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.getUtf8Entry(classFile, cpOffsets[strEntry], scratch);
    }

    public static String getClassName(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String[] strCache, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        if (classFile.get(cpOffsets[cpEntryNumber]) != 7) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.getUtf8Entry(classFile, strEntry, cpOffsets, strCache, scratch);
    }

    public static String getModuleName(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String[] strCache, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        if (classFile.get(cpOffsets[cpEntryNumber]) != 19) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.getUtf8Entry(classFile, strEntry, cpOffsets, strCache, scratch);
    }

    public static String getPackageName(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String[] strCache, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        if (classFile.get(cpOffsets[cpEntryNumber]) != 20) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.getUtf8Entry(classFile, strEntry, cpOffsets, strCache, scratch);
    }

    public static String getUtf8Entry(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        return ClassFileUtil.getUtf8Entry(classFile, cpOffsets[cpEntryNumber], scratch);
    }

    public static String getUtf8Entry(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String[] strCache, StringBuilder scratch) {
        if (cpEntryNumber == 0) {
            return null;
        }
        String str = strCache[cpEntryNumber];
        if (str == null) {
            str = strCache[cpEntryNumber] = ClassFileUtil.getUtf8Entry(classFile, cpEntryNumber, cpOffsets, scratch);
        }
        return str;
    }

    public static String getUtf8Entry(ByteBuffer classFile, int cpEntryOffset, StringBuilder scratch) {
        if (classFile.get(cpEntryOffset) != 1) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int length = classFile.getShort(cpEntryOffset + 1) & 0xFFFF;
        scratch.setLength(0);
        for (int i = 0; i < length; ++i) {
            int a = classFile.get(cpEntryOffset + 3 + i) & 0xFF;
            if (a < 128) {
                scratch.append((char)a);
                continue;
            }
            if (a < 192) {
                scratch.append('\ufffd');
                continue;
            }
            int b = classFile.get(cpEntryOffset + 4 + i) & 0xFF;
            if (b < 128 || b >= 192) {
                scratch.append('\ufffd');
                continue;
            }
            if (a < 224) {
                ++i;
                scratch.append((char)((a & 0x1F) << 6 | b & 0x3F));
                continue;
            }
            int c = classFile.get(cpEntryOffset + 5 + i) & 0xFF;
            if (c < 128 || c >= 192) {
                scratch.append('\ufffd');
                continue;
            }
            if (a < 240) {
                i += 2;
                scratch.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
                continue;
            }
            throw new IllegalStateException("Invalid Modified UTF-8 sequence in class file");
        }
        return scratch.toString();
    }

    public static boolean classNameEquals(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String str) {
        if (classFile.get(cpOffsets[cpEntryNumber]) != 7) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.utf8EntryEquals(classFile, cpOffsets[strEntry], str);
    }

    public static boolean stringEquals(ByteBuffer classFile, int cpEntryNumber, int[] cpOffsets, String str) {
        if (classFile.get(cpOffsets[cpEntryNumber]) != 8) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int strEntry = classFile.getShort(cpOffsets[cpEntryNumber] + 1) & 0xFFFF;
        return ClassFileUtil.utf8EntryEquals(classFile, cpOffsets[strEntry], str);
    }

    public static boolean utf8EntryEquals(ByteBuffer classFile, int cpEntryOffset, String str) {
        int i;
        if (classFile.get(cpEntryOffset) != 1) {
            throw new IllegalStateException("Invalid constant pool entry type");
        }
        int length = classFile.getShort(cpEntryOffset + 1) & 0xFFFF;
        int strLength = str.length();
        int j = 0;
        for (i = 0; i < length && j < strLength; ++i, ++j) {
            int a = classFile.get(cpEntryOffset + 3 + i) & 0xFF;
            if (a < 128) {
                if (str.charAt(j) == (char)a) continue;
                return false;
            }
            if (a < 192) {
                return false;
            }
            int b = classFile.get(cpEntryOffset + 4 + i) & 0xFF;
            if (b < 128 || b >= 192) {
                return false;
            }
            if (a < 224) {
                ++i;
                if (str.charAt(j) == (char)((a & 0x1F) << 6 | b & 0x3F)) continue;
                return false;
            }
            int c = classFile.get(cpEntryOffset + 5 + i) & 0xFF;
            if (c < 128 || c >= 192) {
                return false;
            }
            if (a < 240) {
                i += 2;
                if (str.charAt(j) == (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F)) continue;
                return false;
            }
            throw new IllegalStateException("Invalid Modified UTF-8 sequence in class file");
        }
        return i == length && j == strLength;
    }
}

