/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import io.smallrye.common.constraint.Assert;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.TypeId;

public final class LeafTypeId
extends TypeId {
    private final DefinedTypeDefinition definition;
    private volatile int typeIdValue = -1;

    LeafTypeId(DefinedTypeDefinition definition) {
        this.definition = definition;
    }

    public boolean hasTypeIdValue() {
        return this.typeIdValue != -1;
    }

    public int getTypeIdValue() {
        if (this.typeIdValue == -1) {
            throw new IllegalStateException("Type ID value not assigned");
        }
        return this.typeIdValue;
    }

    public int getTypeIdValueElse(int elseVal) {
        int typeIdValue = this.typeIdValue;
        return typeIdValue == -1 ? elseVal : typeIdValue;
    }

    public void setTypeIdValue(int typeIdValue) {
        Assert.checkMinimumParameter((String)"typeIdValue", (int)0, (int)typeIdValue);
        if (this.typeIdValue != -1) {
            throw new IllegalStateException("Type ID already assigned");
        }
        this.typeIdValue = typeIdValue;
    }

    public DefinedTypeDefinition getTypeDefinition() {
        return this.definition;
    }
}

