/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import io.smallrye.common.constraint.Assert;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.Value;
import org.qbicc.interpreter.VmClass;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NestedClassElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public interface LoadedTypeDefinition
extends DefinedTypeDefinition {
    @Override
    default public LoadedTypeDefinition load() {
        return this;
    }

    public ValueType getType();

    default public <T extends ValueType> T getType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getType()));
    }

    default public ObjectType getObjectType() {
        return this.getType(ObjectType.class);
    }

    default public ClassObjectType getClassType() {
        return this.getType(ClassObjectType.class);
    }

    default public InterfaceObjectType getInterfaceType() {
        return this.getType(InterfaceObjectType.class);
    }

    public LoadedTypeDefinition getSuperClass();

    public LoadedTypeDefinition getInterface(int var1) throws IndexOutOfBoundsException;

    public LoadedTypeDefinition[] getInterfaces();

    public void forEachInterfaceFullImplementedSet(Consumer<LoadedTypeDefinition> var1);

    default public boolean isSubtypeOf(LoadedTypeDefinition other) {
        return this.getObjectType().isSubtypeOf(other.getObjectType());
    }

    public DefinedTypeDefinition getNestHost();

    public DefinedTypeDefinition[] getNestMembers();

    public MethodElement[] getInstanceMethods();

    public NestedClassElement getEnclosingNestedClass();

    public int getEnclosedNestedClassCount();

    public NestedClassElement getEnclosedNestedClass(int var1) throws IndexOutOfBoundsException;

    public FieldElement getField(int var1);

    default public void eachField(Consumer<FieldElement> consumer) {
        int cnt = this.getFieldCount();
        for (int i = 0; i < cnt; ++i) {
            consumer.accept(this.getField(i));
        }
    }

    default public FieldElement resolveField(TypeDescriptor descriptor, String name) {
        return this.resolveField(descriptor, name, false);
    }

    default public FieldElement resolveField(TypeDescriptor descriptor, String name, boolean includeNoResolve) {
        Assert.checkNotNullParam((String)"descriptor", (Object)descriptor);
        Assert.checkNotNullParam((String)"name", (Object)name);
        int idx = this.getFieldIndex(name, includeNoResolve);
        if (idx >= 0) {
            FieldElement field = this.getField(idx);
            if (field.getTypeDescriptor().equals(descriptor)) {
                return field;
            }
            return null;
        }
        int interfaceCount = this.getInterfaceCount();
        for (int i = 0; i < interfaceCount; ++i) {
            LoadedTypeDefinition each = this.getInterface(i);
            FieldElement candidate = each.resolveField(descriptor, name, includeNoResolve);
            if (candidate == null) continue;
            return candidate;
        }
        LoadedTypeDefinition superType = this.getSuperClass();
        return superType != null ? superType.resolveField(descriptor, name, includeNoResolve) : null;
    }

    default public int getFieldIndex(String name) {
        return this.getFieldIndex(name, false);
    }

    default public int getFieldIndex(String name, boolean includeNoResolve) {
        int cnt = this.getFieldCount();
        for (int i = 0; i < cnt; ++i) {
            FieldElement field = this.getField(i);
            if (!includeNoResolve && !field.hasNoModifiersOf(0x1000000) || !field.nameEquals(name)) continue;
            return i;
        }
        return -1;
    }

    default public FieldElement findField(String name) {
        return this.findField(name, false);
    }

    default public FieldElement findField(String name, boolean includeNoResolve) {
        int idx = this.getFieldIndex(name, includeNoResolve);
        return idx == -1 ? null : this.getField(idx);
    }

    default public InstanceFieldElement findInstanceField(String name) {
        return this.findInstanceField(name, false);
    }

    default public InstanceFieldElement findInstanceField(String name, boolean includeNoResolve) {
        InstanceFieldElement ife;
        FieldElement fieldElement;
        int idx = this.getFieldIndex(name, includeNoResolve);
        return idx == -1 ? null : ((fieldElement = this.getField(idx)) instanceof InstanceFieldElement ? (ife = (InstanceFieldElement)fieldElement) : null);
    }

    default public StaticFieldElement findStaticField(String name) {
        return this.findStaticField(name, false);
    }

    default public StaticFieldElement findStaticField(String name, boolean includeNoResolve) {
        StaticFieldElement ife;
        FieldElement fieldElement;
        int idx = this.getFieldIndex(name, includeNoResolve);
        return idx == -1 ? null : ((fieldElement = this.getField(idx)) instanceof StaticFieldElement ? (ife = (StaticFieldElement)fieldElement) : null);
    }

    @Deprecated
    public void injectField(FieldElement var1);

    public Value getInitialValue(FieldElement var1);

    public MethodElement getMethod(int var1);

    public MethodElement expandSigPolyMethod(ClassContext var1, MethodElement var2, MethodDescriptor var3);

    default public int findMethodIndex(String name, MethodDescriptor descriptor, boolean includePrivate) {
        int cnt = this.getMethodCount();
        for (int i = 0; i < cnt; ++i) {
            MethodElement method = this.getMethod(i);
            if (method.hasAllModifiersOf(0x1000000) || method.hasAllModifiersOf(2) && !includePrivate || !method.nameEquals(name)) continue;
            if ((method.getModifiers() & 0x10000) != 0) {
                return i;
            }
            if (!method.getDescriptor().equals(descriptor)) continue;
            return i;
        }
        return -1;
    }

    default public int findMethodIndex(String name, MethodDescriptor descriptor) {
        return this.findMethodIndex(name, descriptor, true);
    }

    default public int findMethodIndex(Predicate<MethodElement> predicate) {
        int cnt = this.getMethodCount();
        for (int i = 0; i < cnt; ++i) {
            MethodElement method = this.getMethod(i);
            if (!predicate.test(method)) continue;
            return i;
        }
        return -1;
    }

    default public int findSingleMethodIndex(Predicate<MethodElement> predicate) {
        int cnt = this.getMethodCount();
        int idx = -1;
        for (int i = 0; i < cnt; ++i) {
            MethodElement method = this.getMethod(i);
            if (!predicate.test(method)) continue;
            if (idx != -1) {
                throw new IllegalArgumentException("Predicate matched more than one method element");
            }
            idx = i;
        }
        return idx;
    }

    default public MethodElement requireSingleMethod(Predicate<MethodElement> predicate) {
        int idx = this.findSingleMethodIndex(predicate);
        if (idx == -1) {
            throw new IllegalArgumentException("No matching method found");
        }
        return this.getMethod(idx);
    }

    default public MethodElement requireSingleMethod(String name) {
        return this.requireSingleMethod((MethodElement me) -> me.nameEquals(name));
    }

    default public MethodElement requireSingleMethod(String name, int argCnt) {
        return this.requireSingleMethod((MethodElement me) -> me.nameEquals(name) && me.getParameters().size() == argCnt);
    }

    default public MethodElement resolveMethodElementExact(ClassContext resolvingContext, String name, MethodDescriptor descriptor) {
        int idx = this.findMethodIndex(name, descriptor);
        return idx == -1 ? null : this.expandSigPolyMethod(resolvingContext, this.getMethod(idx), descriptor);
    }

    default public MethodElement resolveMethodElementVirtual(ClassContext resolvingContext, String name, MethodDescriptor descriptor) {
        return this.resolveMethodElementVirtual(resolvingContext, name, descriptor, true);
    }

    default public MethodElement resolveMethodElementVirtual(ClassContext resolvingContext, String name, MethodDescriptor descriptor, boolean includePrivate) {
        MethodElement superCandidate;
        if (this.isInterface()) {
            throw new IncompatibleClassChangeError(this.getInternalName() + " is an interface");
        }
        int result = this.findMethodIndex(name, descriptor, includePrivate);
        if (result != -1) {
            return this.expandSigPolyMethod(resolvingContext, this.getMethod(result), descriptor);
        }
        LoadedTypeDefinition superClass = this.getSuperClass();
        if (superClass != null && (superCandidate = superClass.resolveMethodElementVirtual(resolvingContext, name, descriptor, false)) != null) {
            return superCandidate;
        }
        return null;
    }

    default public MethodElement resolveMethodElementInterface(String name, MethodDescriptor descriptor) {
        return this.resolveMethodElementInterface(false, name, descriptor);
    }

    default public MethodElement resolveMethodElementInterface(boolean virtualOnly, String name, MethodDescriptor descriptor) {
        MethodElement method;
        int modifiers;
        LoadedTypeDefinition object;
        if (!this.isInterface()) {
            throw new IncompatibleClassChangeError(this.getInternalName() + " is not an interface");
        }
        int result = this.findMethodIndex(name, descriptor, !virtualOnly);
        if (result != -1) {
            return this.getMethod(result);
        }
        if (!virtualOnly && (result = (object = this.getContext().findDefinedType("java/lang/Object").load()).findMethodIndex(name, descriptor)) != -1 && ((modifiers = (method = object.getMethod(result)).getModifiers()) & 9) == 1) {
            return method;
        }
        MethodElement candidate = this.resolveMaximallySpecificMethodInterface(name, descriptor);
        if (candidate != null) {
            return candidate;
        }
        int cnt = this.getInterfaceCount();
        for (int i = 0; i < cnt; ++i) {
            candidate = this.getInterface(i).resolveMethodElementInterface(true, name, descriptor);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private MethodElement resolveMaximallySpecificMethodInterface(String name, MethodDescriptor descriptor) {
        int d = 0;
        MethodElement found;
        while ((found = this.resolveMaximallySpecificMethodInterface(d, name, descriptor)) != MethodElement.NOT_FOUND && found != MethodElement.END_OF_SEARCH) {
            if (found != null) {
                return found;
            }
            ++d;
        }
        return null;
    }

    private MethodElement resolveMaximallySpecificMethodInterface(int depth, String name, MethodDescriptor descriptor) {
        MethodElement candidate = null;
        if (depth > 0) {
            int cnt = this.getInterfaceCount();
            boolean end = true;
            for (int i = 0; i < cnt; ++i) {
                MethodElement found = this.getInterface(i).resolveMaximallySpecificMethodInterface(depth - 1, name, descriptor);
                if (found != null && candidate != null || found == MethodElement.NOT_FOUND) {
                    return MethodElement.NOT_FOUND;
                }
                if (found != MethodElement.END_OF_SEARCH) {
                    end = false;
                }
                candidate = found;
            }
            if (end) {
                return MethodElement.END_OF_SEARCH;
            }
            return candidate;
        }
        int idx = this.findMethodIndex(name, descriptor);
        if (idx != -1 && (this.getMethod(idx).getModifiers() & 0x40A) == 0) {
            return this.getMethod(idx);
        }
        if (this.getInterfaceCount() == 0) {
            return MethodElement.END_OF_SEARCH;
        }
        return null;
    }

    default public void forEachSigPolyInstanceMethod(Consumer<? super InstanceMethodElement> consumer) {
        this.forEachSigPolyInstanceMethod(consumer, Consumer::accept);
    }

    default public void forEachSigPolyMethod(Consumer<? super MethodElement> consumer) {
        this.forEachSigPolyMethod(consumer, Consumer::accept);
    }

    public <T> void forEachSigPolyInstanceMethod(T var1, BiConsumer<T, ? super InstanceMethodElement> var2);

    public <T> void forEachSigPolyMethod(T var1, BiConsumer<T, ? super MethodElement> var2);

    default public void forEachMethod(Consumer<? super MethodElement> consumer) {
        int mc = this.getMethodCount();
        for (int i = 0; i < mc; ++i) {
            consumer.accept(this.getMethod(i));
        }
        this.forEachSigPolyMethod(consumer);
    }

    default public void forEachNonStaticMethod(Consumer<? super InstanceMethodElement> consumer) {
        int mc = this.getMethodCount();
        for (int i = 0; i < mc; ++i) {
            MethodElement method = this.getMethod(i);
            if (method.isStatic()) continue;
            consumer.accept((InstanceMethodElement)method);
        }
        this.forEachSigPolyInstanceMethod(consumer);
    }

    default public <T> void forEachNonStaticMethod(T argument, BiConsumer<T, ? super InstanceMethodElement> consumer) {
        int mc = this.getMethodCount();
        for (int i = 0; i < mc; ++i) {
            MethodElement method = this.getMethod(i);
            if (method.isStatic()) continue;
            consumer.accept(argument, (InstanceMethodElement)method);
        }
        this.forEachSigPolyInstanceMethod(argument, consumer);
    }

    public ConstructorElement getConstructor(int var1);

    default public int findConstructorIndex(MethodDescriptor descriptor) {
        int cnt = this.getConstructorCount();
        for (int i = 0; i < cnt; ++i) {
            if (!this.getConstructor(i).getDescriptor().equals(descriptor)) continue;
            return i;
        }
        return -1;
    }

    default public int findSingleConstructorIndex(Predicate<ConstructorElement> predicate) {
        int cnt = this.getConstructorCount();
        int idx = -1;
        for (int i = 0; i < cnt; ++i) {
            ConstructorElement method = this.getConstructor(i);
            if (!predicate.test(method)) continue;
            if (idx != -1) {
                throw new IllegalArgumentException("Predicate matched more than one constructor element");
            }
            idx = i;
        }
        return idx;
    }

    default public ConstructorElement requireSingleConstructor(Predicate<ConstructorElement> predicate) {
        int idx = this.findSingleConstructorIndex(predicate);
        if (idx == -1) {
            throw new IllegalArgumentException("No matching constructor found");
        }
        return this.getConstructor(idx);
    }

    default public ConstructorElement resolveConstructorElement(MethodDescriptor descriptor) {
        int idx = this.findConstructorIndex(descriptor);
        return idx == -1 ? null : this.getConstructor(idx);
    }

    public InitializerElement getInitializer();

    public int getTypeId();

    public int getMaximumSubtypeId();

    public boolean isTypeIdValid();

    public void assignTypeId(int var1);

    public void assignMaximumSubtypeId(int var1);

    public boolean declaresDefaultMethods();

    public boolean hasDefaultMethods();

    public VmClass getVmClass();

    public void setVmClass(VmClass var1);

    public LoadedTypeDefinition getEnclosingMethodClass();

    public MethodElement getEnclosingMethod();
}

