/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.Value;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.Primitive;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DefinedTypeDefinitionImpl;
import org.qbicc.type.definition.DelegatingDefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.MethodTypeId;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NestedClassElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.TypeSignature;

final class LoadedTypeDefinitionImpl
extends DelegatingDefinedTypeDefinition
implements LoadedTypeDefinition {
    private static final VarHandle vmClassHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "vmClass", VarHandle.class, LoadedTypeDefinitionImpl.class, VmClass.class);
    private final ValueType type;
    private final DefinedTypeDefinitionImpl delegate;
    private final LoadedTypeDefinition superType;
    private final LoadedTypeDefinition[] interfaces;
    private final ArrayList<FieldElement> fields;
    private final MethodElement[] methods;
    private final MethodElement[] instanceMethods;
    private final ConstructorElement[] ctors;
    private final InitializerElement init;
    private final NestedClassElement enclosingClass;
    private final NestedClassElement[] enclosedClasses;
    private final DefinedTypeDefinition nestHost;
    private final DefinedTypeDefinition[] nestMembers;
    private int maximumSubtypeId = -1;
    private final boolean hasDefaultMethods;
    private final boolean declaresDefaultMethods;
    private volatile VmClass vmClass;
    private LoadedTypeDefinition enclosingMethodClass;
    private MethodElement enclosingMethod;
    private volatile Map<MethodElement, Map<MethodTypeId, MethodElement>> sigPolyMethods = null;

    LoadedTypeDefinitionImpl(DefinedTypeDefinitionImpl delegate, LoadedTypeDefinition superType, LoadedTypeDefinition[] interfaces, ArrayList<FieldElement> fields, MethodElement[] methods, MethodElement[] instanceMethods, ConstructorElement[] ctors, InitializerElement init, NestedClassElement enclosingClass, NestedClassElement[] enclosedClasses, DefinedTypeDefinition nestHost, DefinedTypeDefinition[] nestMembers) {
        this.delegate = delegate;
        this.superType = superType;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.instanceMethods = instanceMethods;
        this.ctors = ctors;
        this.init = init;
        this.enclosingClass = enclosingClass;
        this.enclosedClasses = enclosedClasses;
        this.nestHost = nestHost;
        this.nestMembers = nestMembers;
        int interfaceCnt = interfaces.length;
        InterfaceObjectType[] interfaceTypes = new InterfaceObjectType[interfaceCnt];
        for (int i = 0; i < interfaceCnt; ++i) {
            interfaceTypes[i] = interfaces[i].getInterfaceType();
        }
        this.type = this.isPrimitive() ? Primitive.getPrimitiveFor((BaseTypeDescriptor)this.getDescriptor()).getType() : (this.isInterface() ? this.getContext().getTypeSystem().generateInterfaceObjectType(delegate, List.of(interfaceTypes)) : this.getContext().getTypeSystem().generateClassObjectType(delegate, superType == null ? null : superType.getClassType(), List.of(interfaceTypes)));
        boolean buildDeclaresDefaultMethods = false;
        if (this.isInterface()) {
            for (MethodElement method : instanceMethods) {
                if (!method.getEnclosingType().equals(delegate) || method.isStatic() || method.isAbstract()) continue;
                buildDeclaresDefaultMethods = true;
            }
        }
        boolean buildHasDefaultMethods = this.declaresDefaultMethods = buildDeclaresDefaultMethods;
        if (superType != null) {
            buildHasDefaultMethods |= superType.hasDefaultMethods();
        }
        if (!buildHasDefaultMethods) {
            for (LoadedTypeDefinition ltd : interfaces) {
                buildHasDefaultMethods = ltd.hasDefaultMethods();
            }
        }
        this.hasDefaultMethods = buildHasDefaultMethods;
    }

    @Override
    public DefinedTypeDefinition getDelegate() {
        return this.delegate;
    }

    @Override
    public LoadedTypeDefinition load() {
        return this;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public LoadedTypeDefinition getSuperClass() {
        return this.superType;
    }

    @Override
    public LoadedTypeDefinition getInterface(int index) throws IndexOutOfBoundsException {
        return this.interfaces[index];
    }

    @Override
    public LoadedTypeDefinition[] getInterfaces() {
        return (LoadedTypeDefinition[])this.interfaces.clone();
    }

    @Override
    public void forEachInterfaceFullImplementedSet(Consumer<LoadedTypeDefinition> function) {
        ArrayDeque<LoadedTypeDefinitionImpl> worklist = new ArrayDeque<LoadedTypeDefinitionImpl>();
        for (LoadedTypeDefinition cur = this; cur != null; cur = cur.getSuperClass()) {
            Collections.addAll(worklist, cur.getInterfaces());
        }
        if (this.isInterface()) {
            worklist.add(this);
        }
        HashSet<LoadedTypeDefinition> visited = new HashSet<LoadedTypeDefinition>();
        while (!worklist.isEmpty()) {
            LoadedTypeDefinition ltd = (LoadedTypeDefinition)worklist.pop();
            if (!visited.add(ltd)) continue;
            function.accept(ltd);
            Collections.addAll(worklist, ltd.getInterfaces());
        }
    }

    @Override
    public DefinedTypeDefinition getNestHost() {
        return this.nestHost;
    }

    @Override
    public DefinedTypeDefinition[] getNestMembers() {
        return this.nestMembers;
    }

    @Override
    public MethodElement[] getInstanceMethods() {
        return this.instanceMethods;
    }

    @Override
    public NestedClassElement getEnclosingNestedClass() {
        return this.enclosingClass;
    }

    @Override
    public int getEnclosedNestedClassCount() {
        return this.enclosedClasses.length;
    }

    @Override
    public NestedClassElement getEnclosedNestedClass(int index) throws IndexOutOfBoundsException {
        return this.enclosedClasses[index];
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public FieldElement getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public void injectField(FieldElement field) {
        Assert.checkNotNullParam((String)"field", (Object)field);
        if ((field.getModifiers() & 0x1000000) == 0) {
            throw new IllegalArgumentException("Injected fields must be unresolvable");
        }
        this.fields.add(field);
    }

    @Override
    public Value getInitialValue(FieldElement field) {
        return this.vmClass == null ? ((StaticFieldElement)field).getInitialValue() : this.vmClass.getValueForStaticField(field);
    }

    @Override
    public int getMethodCount() {
        return this.methods.length;
    }

    @Override
    public MethodElement getMethod(int index) {
        return this.methods[index];
    }

    @Override
    public MethodElement expandSigPolyMethod(ClassContext resolvingContext, MethodElement original, MethodDescriptor descriptor) {
        if (original.isSignaturePolymorphic()) {
            MethodTypeId methodType = resolvingContext.resolveMethodType(descriptor);
            if (methodType == null) {
                return null;
            }
            return this.getSigPolyMethods().computeIfAbsent(original, LoadedTypeDefinitionImpl::newMap).computeIfAbsent(methodType, mt -> {
                MethodDescriptor desc = mt.getDescriptor();
                MethodElement.Builder builder = MethodElement.builder(original.getName(), desc, original.getIndex());
                builder.setSignature(MethodSignature.synthesize(this.getContext(), desc));
                builder.setEnclosingType(original.getEnclosingType());
                builder.setMinimumLineNumber(original.getMinimumLineNumber());
                builder.setMaximumLineNumber(original.getMaximumLineNumber());
                builder.setModifiers(original.getModifiers() & 0xFFFEFFFF & 0xFFFFFFEF & 0xFFFFFEFF | 0x1000);
                MethodBodyFactory origFactory = original.getMethodBodyFactory();
                if (origFactory != null) {
                    builder.setMethodBodyFactory(origFactory, original.getMethodBodyFactoryIndex());
                }
                builder.addInvisibleAnnotations(original.getInvisibleAnnotations());
                builder.addVisibleAnnotations(original.getVisibleAnnotations());
                List<TypeDescriptor> parameterTypes = desc.getParameterTypes();
                int cnt = parameterTypes.size();
                ArrayList<ParameterElement> params = new ArrayList<ParameterElement>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    ParameterElement.Builder pb = ParameterElement.builder("p" + i, parameterTypes.get(i), i);
                    pb.setEnclosingType(original.getEnclosingType());
                    pb.setTypeParameterContext(original);
                    pb.setSignature(TypeSignature.synthesize(this.getContext(), pb.getDescriptor()));
                    params.add(pb.build());
                }
                builder.setParameters(params);
                return builder.build();
            });
        }
        return original;
    }

    private static <K, V> Map<K, V> newMap(Object ignored) {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MethodElement, Map<MethodTypeId, MethodElement>> getSigPolyMethods() {
        Map<MethodElement, Map<MethodTypeId, MethodElement>> sigPolyMethods = this.sigPolyMethods;
        if (sigPolyMethods == null) {
            LoadedTypeDefinitionImpl loadedTypeDefinitionImpl = this;
            synchronized (loadedTypeDefinitionImpl) {
                sigPolyMethods = this.sigPolyMethods;
                if (sigPolyMethods == null) {
                    this.sigPolyMethods = sigPolyMethods = new ConcurrentHashMap<MethodElement, Map<MethodTypeId, MethodElement>>();
                }
            }
        }
        return sigPolyMethods;
    }

    @Override
    public <T> void forEachSigPolyInstanceMethod(T arg, BiConsumer<T, ? super InstanceMethodElement> consumer) {
        Map<MethodElement, Map<MethodTypeId, MethodElement>> sigPolyMethods = this.sigPolyMethods;
        if (sigPolyMethods != null) {
            for (Map<MethodTypeId, MethodElement> subMap : sigPolyMethods.values()) {
                for (MethodElement element : subMap.values()) {
                    if (!(element instanceof InstanceMethodElement)) continue;
                    InstanceMethodElement ime = (InstanceMethodElement)element;
                    consumer.accept(arg, ime);
                }
            }
        }
    }

    @Override
    public <T> void forEachSigPolyMethod(T arg, BiConsumer<T, ? super MethodElement> consumer) {
        Map<MethodElement, Map<MethodTypeId, MethodElement>> sigPolyMethods = this.sigPolyMethods;
        if (sigPolyMethods != null) {
            for (Map<MethodTypeId, MethodElement> subMap : sigPolyMethods.values()) {
                for (MethodElement element : subMap.values()) {
                    consumer.accept(arg, element);
                }
            }
        }
    }

    @Override
    public int getConstructorCount() {
        return this.ctors.length;
    }

    @Override
    public ConstructorElement getConstructor(int index) {
        return this.ctors[index];
    }

    @Override
    public InitializerElement getInitializer() {
        return this.init;
    }

    @Override
    public int getTypeId() {
        return this.typeId().getTypeIdValue();
    }

    @Override
    public int getMaximumSubtypeId() {
        return this.maximumSubtypeId;
    }

    @Override
    public boolean isTypeIdValid() {
        return this.typeId().hasTypeIdValue();
    }

    @Override
    public void assignTypeId(int myTypeId) {
        this.typeId().setTypeIdValue(myTypeId);
    }

    @Override
    public void assignMaximumSubtypeId(int subTypeId) {
        Assert.assertTrue((this.maximumSubtypeId == -1 ? 1 : 0) != 0);
        this.maximumSubtypeId = subTypeId;
    }

    @Override
    public boolean declaresDefaultMethods() {
        Assert.assertTrue((this.isInterface() || !this.declaresDefaultMethods ? 1 : 0) != 0);
        return this.declaresDefaultMethods;
    }

    @Override
    public boolean hasDefaultMethods() {
        return this.hasDefaultMethods;
    }

    @Override
    public VmClass getVmClass() {
        VmClass vmClass = this.vmClass;
        if (vmClass == null) {
            Vm vm = this.getContext().getCompilationContext().getVm();
            vmClass = vm.getClassLoaderForContext(this.getContext()).getOrDefineClass(this);
            this.setVmClass(vmClass);
        }
        return vmClass;
    }

    @Override
    public void setVmClass(VmClass vmClass) {
        VmClass res = vmClassHandle.compareAndExchange(this, null, vmClass);
        if (res != null && res != vmClass) {
            throw new IllegalStateException("VmClass already set for " + this);
        }
    }

    @Override
    public LoadedTypeDefinition getEnclosingMethodClass() {
        LoadedTypeDefinition emc = this.enclosingMethodClass;
        if (emc == null) {
            String emcName = this.delegate.enclosingMethodClassName;
            if (emcName == null) {
                return null;
            }
            DefinedTypeDefinition definedType = this.getContext().findDefinedType(emcName);
            if (definedType == null) {
                return null;
            }
            this.enclosingMethodClass = emc = definedType.load();
        }
        return emc;
    }

    @Override
    public MethodElement getEnclosingMethod() {
        MethodElement em = this.enclosingMethod;
        if (em == null) {
            int emIdx;
            LoadedTypeDefinition emc = this.getEnclosingMethodClass();
            if (emc == null) {
                return null;
            }
            String emName = this.delegate.enclosingMethodName;
            MethodDescriptor emDesc = this.delegate.enclosingMethodDesc;
            if (emName != null && emDesc != null && (emIdx = emc.findMethodIndex(emName, emDesc)) != -1) {
                this.enclosingMethod = em = emc.getMethod(emIdx);
            }
        }
        return em;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

