/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import java.nio.ByteBuffer;
import org.qbicc.type.definition.ModuleDefinitionImpl;

public interface ModuleDefinition {
    public static ModuleDefinition create(ByteBuffer buffer) {
        return new ModuleDefinitionImpl(buffer);
    }

    public String getName();

    public String getVersion();

    public int getModifiers();

    default public boolean hasAllModifiersOf(int mask) {
        return (this.getModifiers() & mask) == mask;
    }

    default public boolean hasNoModifiersOf(int mask) {
        return (this.getModifiers() & mask) == mask;
    }

    default public boolean isOpen() {
        return this.hasAllModifiersOf(16);
    }

    default public boolean isSynthetic() {
        return this.hasAllModifiersOf(4096);
    }

    default public boolean isMandated() {
        return this.hasAllModifiersOf(32768);
    }

    public int getPackageCount();

    public String getPackage(int var1) throws IndexOutOfBoundsException;

    public int getRequiresCount();

    public String getRequiresName(int var1) throws IndexOutOfBoundsException;

    public int getRequiresModifiers(int var1) throws IndexOutOfBoundsException;

    public String getRequiresVersion(int var1) throws IndexOutOfBoundsException;

    public int getExportsCount();

    public String getExportsPackageName(int var1) throws IndexOutOfBoundsException;

    public int getExportsModifiers(int var1) throws IndexOutOfBoundsException;

    public int getExportsToCount(int var1) throws IndexOutOfBoundsException;

    public String getExportsTo(int var1, int var2) throws IndexOutOfBoundsException;

    public int getOpensCount();

    public String getOpensPackageName(int var1) throws IndexOutOfBoundsException;

    public int getOpensModifiers(int var1) throws IndexOutOfBoundsException;

    public int getOpensToCount(int var1) throws IndexOutOfBoundsException;

    public String getOpensTo(int var1, int var2) throws IndexOutOfBoundsException;

    public int getUsesCount();

    public String getUses(int var1) throws IndexOutOfBoundsException;

    public int getProvidesCount();

    public String getProvides(int var1) throws IndexOutOfBoundsException;

    public int getProvidesWithCount(int var1);

    public String getProvidesWith(int var1, int var2) throws IndexOutOfBoundsException;
}

