/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.nio.ByteBuffer;
import org.qbicc.type.definition.classfile.BufferBacked;

abstract class AbstractBufferBacked
implements BufferBacked {
    final ByteBuffer buffer;

    AbstractBufferBacked(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ByteBuffer getBackingBuffer() {
        return this.buffer;
    }

    @Override
    public int getByte(int index) {
        return this.buffer.get(index) & 0xFF;
    }

    @Override
    public int getShort(int index) {
        return this.buffer.getShort(index) & 0xFFFF;
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public boolean utf8TextEquals(int offset, int length, String str) {
        int i;
        int strLength = str.length();
        int j = 0;
        for (i = 0; i < length && j < strLength; ++i, ++j) {
            int a = this.getByte(offset + i);
            if (a < 128) {
                if (str.charAt(j) == (char)a) continue;
                return false;
            }
            if (a < 192) {
                return false;
            }
            int b = this.getByte(offset + i + 1);
            if (b < 128 || b >= 192) {
                return false;
            }
            if (a < 224) {
                ++i;
                if (str.charAt(j) == (char)((a & 0x1F) << 6 | b & 0x3F)) continue;
                return false;
            }
            int c = this.getByte(offset + i + 2);
            if (c < 128 || c >= 192) {
                return false;
            }
            if (a < 240) {
                i += 2;
                if (str.charAt(j) == (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F)) continue;
                return false;
            }
            throw new IllegalStateException("Invalid Modified UTF-8 sequence in class file");
        }
        return i == length && j == strLength;
    }

    @Override
    public String getUtf8Text(int offset, int length, StringBuilder scratch) {
        scratch.setLength(0);
        int i = 0;
        while (i < length) {
            int c;
            int b;
            int a;
            if ((a = this.getByte(offset + i++)) < 128) {
                scratch.append((char)a);
                continue;
            }
            if (a < 192) {
                scratch.append('\ufffd');
                continue;
            }
            if ((b = this.getByte(offset + i++)) < 128 || b >= 192) {
                scratch.append('\ufffd');
                continue;
            }
            if (a < 224) {
                scratch.append((char)((a & 0x1F) << 6 | b & 0x3F));
                continue;
            }
            if ((c = this.getByte(offset + i++)) < 128 || c >= 192) {
                scratch.append('\ufffd');
                continue;
            }
            if (a < 240) {
                scratch.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
                continue;
            }
            throw new IllegalStateException("Invalid Modified UTF-8 sequence in class file");
        }
        return scratch.toString();
    }

    @Override
    public ByteBuffer slice(int offset, int length) {
        return this.buffer.duplicate().position(offset).limit(offset + length).slice().order(this.buffer.order());
    }
}

