/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.Maps;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.classfile.ClassMethodInfo;
import org.qbicc.type.definition.classfile.MethodParser;
import org.qbicc.type.generic.TypeParameterContext;

public final class BciRangeExceptionHandlerBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Slot THROWN = Slot.thrown();
    private static final Slot STACK0 = Slot.stack(0);
    private final int startBci;
    private final int endBci;
    private final int handlerBci;
    private final ClassObjectType exType;
    private final ClassObjectType throwableType;
    private final MethodParser mp;

    private BciRangeExceptionHandlerBasicBlockBuilder(BasicBlockBuilder delegate, int startBci, int endBci, int handlerBci, ClassObjectType exType, MethodParser mp) {
        super(delegate);
        this.startBci = startBci;
        this.endBci = endBci;
        this.handlerBci = handlerBci;
        this.exType = exType;
        this.throwableType = this.getContext().getBootstrapClassContext().findDefinedType("java/lang/Throwable").load().getClassType();
        this.mp = mp;
    }

    private boolean inRange() {
        int bci = this.getBytecodeIndex();
        return this.startBci <= bci && bci < this.endBci;
    }

    @Override
    public BasicBlock throw_(Value value) {
        if (this.inRange()) {
            BlockLabel handler = this.mp.getOrCreateBlockForIndex(this.handlerBci);
            return this.enterHandler(value, handler, this.mp.captureOutbound());
        }
        return super.throw_(value);
    }

    @Override
    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        if (this.inRange() && !targetPtr.isNoThrow()) {
            Map<Slot, Value> capture = this.mp.captureOutbound();
            BlockLabel resumeLabel = new BlockLabel();
            BlockLabel handlerLabel = new BlockLabel();
            Value rv = this.invoke(targetPtr, receiver, arguments, BlockLabel.of(this.begin(handlerLabel, this, (bbb, fb) -> bbb.beginHandler(handlerLabel, capture))), resumeLabel, capture);
            this.begin(resumeLabel);
            return this.addParam(resumeLabel, Slot.result(), rv.getType(), rv.isNullable());
        }
        return super.call(targetPtr, receiver, arguments);
    }

    @Override
    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        if (this.inRange() && !targetPtr.isNoThrow()) {
            Map<Slot, Value> capture = this.mp.captureOutbound();
            BlockLabel handlerLabel = new BlockLabel();
            return this.invokeNoReturn(targetPtr, receiver, arguments, BlockLabel.of(this.begin(handlerLabel, this, (bbb, fb) -> bbb.beginHandler(handlerLabel, capture))), Map.of());
        }
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    @Override
    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        if (this.inRange() && !targetPtr.isNoThrow()) {
            this.return_(this.call(targetPtr, receiver, arguments));
        }
        return super.tailCall(targetPtr, receiver, arguments);
    }

    private void beginHandler(BlockLabel handlerLabel, Map<Slot, Value> capture) {
        this.enterHandler(this.addParam(handlerLabel, THROWN, this.throwableType.getReference(), false), this.mp.getOrCreateBlockForIndex(this.handlerBci), capture);
    }

    private BasicBlock enterHandler(Value ex, BlockLabel handler, Map<Slot, Value> args) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        int oldBci = fb.setBytecodeIndex(this.handlerBci);
        ReferenceType narrowedType = ex.getType(ReferenceType.class).narrow(this.exType);
        Value narrowed = narrowedType == null ? null : fb.bitCast(ex, narrowedType);
        Map adjustedArgs = narrowed == null ? args : Maps.immutable.ofMap(args).newWithKeyValue((Object)STACK0, (Object)narrowed).castToMap();
        ReferenceType actualType = ex.getType(ReferenceType.class);
        if (actualType.instanceOf(this.exType)) {
            return fb.goto_(handler, adjustedArgs);
        }
        if (actualType.getUpperBound().isSupertypeOf(this.exType)) {
            return fb.if_(fb.instanceOf(ex, this.exType), handler, BlockLabel.of(fb.begin(new BlockLabel(), unused -> {
                fb.setBytecodeIndex(oldBci);
                super.throw_(ex);
            })), adjustedArgs);
        }
        assert (narrowed == null);
        fb.setBytecodeIndex(oldBci);
        return super.throw_(ex);
    }

    public static BasicBlockBuilder createIfNeeded(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        if (!fc.has(MethodParser.class)) {
            return delegate;
        }
        MethodParser mp = fc.get(MethodParser.class);
        ClassMethodInfo info = mp.getClassMethodInfo();
        int len = info.getExTableLen();
        for (int i = len - 1; i >= 0; --i) {
            int startPc = info.getExTableEntryStartPc(i);
            int endPc = info.getExTableEntryEndPc(i);
            int handlerPc = info.getExTableEntryHandlerPc(i);
            int typeIdx = info.getExTableEntryTypeIdx(i);
            ClassObjectType exType = typeIdx == 0 ? delegate.getCurrentClassContext().findDefinedType("java/lang/Throwable").load().getClassType() : (ClassObjectType)info.getClassFile().getTypeConstant(typeIdx, TypeParameterContext.of(delegate.getCurrentElement()));
            delegate = new BciRangeExceptionHandlerBasicBlockBuilder(delegate, startPc, endPc, handlerPc, exType, mp);
        }
        return delegate;
    }
}

