/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.qbicc.context.ClassContext;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.classfile.ClassFileImpl;
import org.qbicc.type.definition.classfile.ClassFormatException;
import org.qbicc.type.definition.classfile.ConstantTypeMismatchException;
import org.qbicc.type.descriptor.Descriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodHandleConstant;

public interface ClassFile
extends FieldResolver,
MethodResolver,
ConstructorResolver,
InitializerResolver {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_Dynamic = 17;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final int CONSTANT_Module = 19;
    public static final int CONSTANT_Package = 20;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_OPEN = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MODULE = 32768;
    public static final int ACC_MANDATED = 32768;
    public static final int I_ACC_SIGNATURE_POLYMORPHIC = 65536;
    public static final int I_ACC_NOT_REALLY_FINAL = 65536;
    public static final int I_ACC_PRIMITIVE = 131072;
    public static final int I_ACC_NO_SAFEPOINTS = 131072;
    public static final int I_ACC_HIDDEN = 262144;
    public static final int I_ACC_THREAD_LOCAL = 524288;
    public static final int I_ACC_ALWAYS_INLINE = 0x100000;
    public static final int I_ACC_NEVER_INLINE = 0x200000;
    public static final int I_ACC_NO_SIDE_EFFECTS = 0x400000;
    public static final int I_ACC_NO_REFLECT = 0x800000;
    public static final int I_ACC_NO_RESOLVE = 0x1000000;
    public static final int I_ACC_NO_RETURN = 0x2000000;
    public static final int I_ACC_NO_THROW = 0x4000000;
    public static final int I_ACC_FOLD = 0x8000000;
    public static final int I_ACC_RUN_TIME = 0x10000000;
    public static final int I_ACC_CALLER_SENSITIVE = 0x20000000;
    public static final int I_ACC_BUILD_TIME_ONLY = 0x40000000;
    public static final int I_ACC_EXTENDED_BITMAP = Integer.MIN_VALUE;
    public static final int OP_NOP = 0;
    public static final int OP_ACONST_NULL = 1;
    public static final int OP_ICONST_M1 = 2;
    public static final int OP_ICONST_0 = 3;
    public static final int OP_ICONST_1 = 4;
    public static final int OP_ICONST_2 = 5;
    public static final int OP_ICONST_3 = 6;
    public static final int OP_ICONST_4 = 7;
    public static final int OP_ICONST_5 = 8;
    public static final int OP_LCONST_0 = 9;
    public static final int OP_LCONST_1 = 10;
    public static final int OP_FCONST_0 = 11;
    public static final int OP_FCONST_1 = 12;
    public static final int OP_FCONST_2 = 13;
    public static final int OP_DCONST_0 = 14;
    public static final int OP_DCONST_1 = 15;
    public static final int OP_BIPUSH = 16;
    public static final int OP_SIPUSH = 17;
    public static final int OP_LDC = 18;
    public static final int OP_LDC_W = 19;
    public static final int OP_LDC2_W = 20;
    public static final int OP_ILOAD = 21;
    public static final int OP_LLOAD = 22;
    public static final int OP_FLOAD = 23;
    public static final int OP_DLOAD = 24;
    public static final int OP_ALOAD = 25;
    public static final int OP_ILOAD_0 = 26;
    public static final int OP_ILOAD_1 = 27;
    public static final int OP_ILOAD_2 = 28;
    public static final int OP_ILOAD_3 = 29;
    public static final int OP_LLOAD_0 = 30;
    public static final int OP_LLOAD_1 = 31;
    public static final int OP_LLOAD_2 = 32;
    public static final int OP_LLOAD_3 = 33;
    public static final int OP_FLOAD_0 = 34;
    public static final int OP_FLOAD_1 = 35;
    public static final int OP_FLOAD_2 = 36;
    public static final int OP_FLOAD_3 = 37;
    public static final int OP_DLOAD_0 = 38;
    public static final int OP_DLOAD_1 = 39;
    public static final int OP_DLOAD_2 = 40;
    public static final int OP_DLOAD_3 = 41;
    public static final int OP_ALOAD_0 = 42;
    public static final int OP_ALOAD_1 = 43;
    public static final int OP_ALOAD_2 = 44;
    public static final int OP_ALOAD_3 = 45;
    public static final int OP_IALOAD = 46;
    public static final int OP_LALOAD = 47;
    public static final int OP_FALOAD = 48;
    public static final int OP_DALOAD = 49;
    public static final int OP_AALOAD = 50;
    public static final int OP_BALOAD = 51;
    public static final int OP_CALOAD = 52;
    public static final int OP_SALOAD = 53;
    public static final int OP_ISTORE = 54;
    public static final int OP_LSTORE = 55;
    public static final int OP_FSTORE = 56;
    public static final int OP_DSTORE = 57;
    public static final int OP_ASTORE = 58;
    public static final int OP_ISTORE_0 = 59;
    public static final int OP_ISTORE_1 = 60;
    public static final int OP_ISTORE_2 = 61;
    public static final int OP_ISTORE_3 = 62;
    public static final int OP_LSTORE_0 = 63;
    public static final int OP_LSTORE_1 = 64;
    public static final int OP_LSTORE_2 = 65;
    public static final int OP_LSTORE_3 = 66;
    public static final int OP_FSTORE_0 = 67;
    public static final int OP_FSTORE_1 = 68;
    public static final int OP_FSTORE_2 = 69;
    public static final int OP_FSTORE_3 = 70;
    public static final int OP_DSTORE_0 = 71;
    public static final int OP_DSTORE_1 = 72;
    public static final int OP_DSTORE_2 = 73;
    public static final int OP_DSTORE_3 = 74;
    public static final int OP_ASTORE_0 = 75;
    public static final int OP_ASTORE_1 = 76;
    public static final int OP_ASTORE_2 = 77;
    public static final int OP_ASTORE_3 = 78;
    public static final int OP_IASTORE = 79;
    public static final int OP_LASTORE = 80;
    public static final int OP_FASTORE = 81;
    public static final int OP_DASTORE = 82;
    public static final int OP_AASTORE = 83;
    public static final int OP_BASTORE = 84;
    public static final int OP_CASTORE = 85;
    public static final int OP_SASTORE = 86;
    public static final int OP_POP = 87;
    public static final int OP_POP2 = 88;
    public static final int OP_DUP = 89;
    public static final int OP_DUP_X1 = 90;
    public static final int OP_DUP_X2 = 91;
    public static final int OP_DUP2 = 92;
    public static final int OP_DUP2_X1 = 93;
    public static final int OP_DUP2_X2 = 94;
    public static final int OP_SWAP = 95;
    public static final int OP_IADD = 96;
    public static final int OP_LADD = 97;
    public static final int OP_FADD = 98;
    public static final int OP_DADD = 99;
    public static final int OP_ISUB = 100;
    public static final int OP_LSUB = 101;
    public static final int OP_FSUB = 102;
    public static final int OP_DSUB = 103;
    public static final int OP_IMUL = 104;
    public static final int OP_LMUL = 105;
    public static final int OP_FMUL = 106;
    public static final int OP_DMUL = 107;
    public static final int OP_IDIV = 108;
    public static final int OP_LDIV = 109;
    public static final int OP_FDIV = 110;
    public static final int OP_DDIV = 111;
    public static final int OP_IREM = 112;
    public static final int OP_LREM = 113;
    public static final int OP_FREM = 114;
    public static final int OP_DREM = 115;
    public static final int OP_INEG = 116;
    public static final int OP_LNEG = 117;
    public static final int OP_FNEG = 118;
    public static final int OP_DNEG = 119;
    public static final int OP_ISHL = 120;
    public static final int OP_LSHL = 121;
    public static final int OP_ISHR = 122;
    public static final int OP_LSHR = 123;
    public static final int OP_IUSHR = 124;
    public static final int OP_LUSHR = 125;
    public static final int OP_IAND = 126;
    public static final int OP_LAND = 127;
    public static final int OP_IOR = 128;
    public static final int OP_LOR = 129;
    public static final int OP_IXOR = 130;
    public static final int OP_LXOR = 131;
    public static final int OP_IINC = 132;
    public static final int OP_I2L = 133;
    public static final int OP_I2F = 134;
    public static final int OP_I2D = 135;
    public static final int OP_L2I = 136;
    public static final int OP_L2F = 137;
    public static final int OP_L2D = 138;
    public static final int OP_F2I = 139;
    public static final int OP_F2L = 140;
    public static final int OP_F2D = 141;
    public static final int OP_D2I = 142;
    public static final int OP_D2L = 143;
    public static final int OP_D2F = 144;
    public static final int OP_I2B = 145;
    public static final int OP_I2C = 146;
    public static final int OP_I2S = 147;
    public static final int OP_LCMP = 148;
    public static final int OP_FCMPL = 149;
    public static final int OP_FCMPG = 150;
    public static final int OP_DCMPL = 151;
    public static final int OP_DCMPG = 152;
    public static final int OP_IFEQ = 153;
    public static final int OP_IFNE = 154;
    public static final int OP_IFLT = 155;
    public static final int OP_IFGE = 156;
    public static final int OP_IFGT = 157;
    public static final int OP_IFLE = 158;
    public static final int OP_IF_ICMPEQ = 159;
    public static final int OP_IF_ICMPNE = 160;
    public static final int OP_IF_ICMPLT = 161;
    public static final int OP_IF_ICMPGE = 162;
    public static final int OP_IF_ICMPGT = 163;
    public static final int OP_IF_ICMPLE = 164;
    public static final int OP_IF_ACMPEQ = 165;
    public static final int OP_IF_ACMPNE = 166;
    public static final int OP_GOTO = 167;
    public static final int OP_JSR = 168;
    public static final int OP_RET = 169;
    public static final int OP_TABLESWITCH = 170;
    public static final int OP_LOOKUPSWITCH = 171;
    public static final int OP_IRETURN = 172;
    public static final int OP_LRETURN = 173;
    public static final int OP_FRETURN = 174;
    public static final int OP_DRETURN = 175;
    public static final int OP_ARETURN = 176;
    public static final int OP_RETURN = 177;
    public static final int OP_GETSTATIC = 178;
    public static final int OP_PUTSTATIC = 179;
    public static final int OP_GETFIELD = 180;
    public static final int OP_PUTFIELD = 181;
    public static final int OP_INVOKEVIRTUAL = 182;
    public static final int OP_INVOKESPECIAL = 183;
    public static final int OP_INVOKESTATIC = 184;
    public static final int OP_INVOKEINTERFACE = 185;
    public static final int OP_INVOKEDYNAMIC = 186;
    public static final int OP_NEW = 187;
    public static final int OP_NEWARRAY = 188;
    public static final int OP_ANEWARRAY = 189;
    public static final int OP_ARRAYLENGTH = 190;
    public static final int OP_ATHROW = 191;
    public static final int OP_CHECKCAST = 192;
    public static final int OP_INSTANCEOF = 193;
    public static final int OP_MONITORENTER = 194;
    public static final int OP_MONITOREXIT = 195;
    public static final int OP_WIDE = 196;
    public static final int OP_MULTIANEWARRAY = 197;
    public static final int OP_IFNULL = 198;
    public static final int OP_IFNONNULL = 199;
    public static final int OP_GOTO_W = 200;
    public static final int OP_JSR_W = 201;
    public static final int OP_BREAKPOINT = 202;
    public static final int OP_IMPDEP1 = 254;
    public static final int OP_IMPDEP2 = 255;
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;

    public ClassContext getClassContext();

    public ByteBuffer getBackingBuffer();

    public int getMajorVersion();

    public int getMinorVersion();

    default public int compareVersion(int major, int minor) {
        int res = Integer.compare(this.getMajorVersion(), major);
        if (res == 0) {
            res = Integer.compare(this.getMinorVersion(), minor);
        }
        return res;
    }

    public int getConstantCount();

    public int getConstantType(int var1);

    default public String getClassConstantName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        return this.getUtf8Constant(this.getClassConstantNameIdx(idx));
    }

    default public boolean classConstantNameEquals(int idx, String expect) {
        return this.utf8ConstantEquals(this.getClassConstantNameIdx(idx), expect);
    }

    default public int getClassConstantNameIdx(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        if (idx == 0) {
            return 0;
        }
        this.checkConstantType(idx, 7);
        return this.getRawConstantShort(idx, 1);
    }

    default public String getStringConstant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        if (idx == 0) {
            return null;
        }
        this.checkConstantType(idx, 8);
        return this.getUtf8Constant(this.getRawConstantShort(idx, 1));
    }

    default public long getLongConstant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 5);
        return this.getRawConstantLong(idx, 1);
    }

    default public int getIntConstant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 3);
        return this.getRawConstantInt(idx, 1);
    }

    default public float getFloatConstant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 4);
        return Float.intBitsToFloat(this.getRawConstantInt(idx, 1));
    }

    default public double getDoubleConstant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 6);
        return Double.longBitsToDouble(this.getRawConstantLong(idx, 1));
    }

    default public String getFieldrefConstantClassName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 9);
        return this.getClassConstantName(this.getRawConstantShort(idx, 1));
    }

    default public int getFieldrefConstantClassIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 9);
        return this.getRawConstantShort(idx, 1);
    }

    default public int getFieldrefNameAndTypeIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 9);
        return this.getRawConstantShort(idx, 3);
    }

    default public int getFieldrefConstantDescriptorIdx(int idx) {
        this.checkConstantType(idx, 9);
        return this.getNameAndTypeConstantDescriptorIdx(this.getRawConstantShort(idx, 3));
    }

    default public String getMethodrefConstantClassName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 10, 11);
        return this.getClassConstantName(this.getRawConstantShort(idx, 1));
    }

    default public int getMethodrefConstantClassIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 10, 11);
        return this.getRawConstantShort(idx, 1);
    }

    default public int getMethodrefNameAndTypeIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 10, 11);
        return this.getRawConstantShort(idx, 3);
    }

    default public String getMethodrefConstantName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 10, 11);
        return this.getNameAndTypeConstantName(this.getRawConstantShort(idx, 3));
    }

    default public boolean methodrefConstantNameEquals(int idx, String expected) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 10, 11);
        return this.nameAndTypeConstantNameEquals(this.getRawConstantShort(idx, 3), expected);
    }

    default public int getInterfaceMethodrefConstantClassIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 11, 11);
        return this.getRawConstantShort(idx, 1);
    }

    default public int getInterfaceMethodrefNameAndTypeIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 11);
        return this.getRawConstantShort(idx, 3);
    }

    default public String getInterfaceMethodrefConstantName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 11);
        return this.getNameAndTypeConstantName(this.getRawConstantShort(idx, 3));
    }

    default public boolean interfaceMethodrefConstantNameEquals(int idx, String expected) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 11);
        return this.nameAndTypeConstantNameEquals(this.getRawConstantShort(idx, 3), expected);
    }

    default public String getNameAndTypeConstantName(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 12);
        return this.getUtf8Constant(this.getRawConstantShort(idx, 1));
    }

    default public boolean nameAndTypeConstantNameEquals(int idx, String expected) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 12);
        return this.utf8ConstantEquals(this.getRawConstantShort(idx, 1), expected);
    }

    default public int getNameAndTypeConstantDescriptorIdx(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 12);
        return this.getRawConstantShort(idx, 3);
    }

    default public Descriptor getNameAndTypeConstantDescriptor(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 12);
        return this.getDescriptorConstant(this.getRawConstantShort(idx, 3));
    }

    default public int getInvokeDynamicBootstrapMethodIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 18);
        return this.getRawConstantShort(idx, 1);
    }

    default public int getInvokeDynamicNameAndTypeIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 18);
        return this.getRawConstantShort(idx, 3);
    }

    default public int getMethodHandleReferenceKind(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 15);
        return this.getRawConstantByte(idx, 1);
    }

    default public int getMethodHandleReferenceIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 15);
        return this.getRawConstantShort(idx, 3);
    }

    default public int getMethodTypeDescriptorIndex(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 16);
        return this.getRawConstantShort(idx, 1);
    }

    public int getBootstrapMethodHandleRef(int var1) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public int getBootstrapMethodArgumentCount(int var1) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public int getBootstrapMethodArgumentConstantIndex(int var1, int var2) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public boolean utf8ConstantEquals(int var1, String var2) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public String getUtf8Constant(int var1) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public ByteBuffer getUtf8ConstantAsBuffer(int var1) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    default public int getUtf8ConstantLength(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 1);
        return this.getRawConstantShort(idx, 1);
    }

    public void checkConstantType(int var1, int var2) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public void checkConstantType(int var1, int var2, int var3) throws IndexOutOfBoundsException, ConstantTypeMismatchException;

    public int getRawConstantByte(int var1, int var2) throws IndexOutOfBoundsException;

    public int getRawConstantShort(int var1, int var2) throws IndexOutOfBoundsException;

    public int getRawConstantInt(int var1, int var2) throws IndexOutOfBoundsException;

    public long getRawConstantLong(int var1, int var2) throws IndexOutOfBoundsException;

    public int getAccess();

    public String getName();

    public String getSuperClassName();

    public int getInterfaceNameCount();

    public String getInterfaceName(int var1);

    public Descriptor getDescriptorConstant(int var1);

    public TypeDescriptor getClassConstantAsDescriptor(int var1);

    public MethodHandleConstant getMethodHandleConstant(int var1);

    public int getFieldCount();

    public int getFieldModifiers(int var1);

    public String getFieldName(int var1);

    public TypeDescriptor getFieldDescriptor(int var1);

    public int getFieldAttributeCount(int var1) throws IndexOutOfBoundsException;

    public boolean fieldAttributeNameEquals(int var1, int var2, String var3) throws IndexOutOfBoundsException;

    public int getFieldRawAttributeByte(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public int getFieldRawAttributeShort(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public int getFieldRawAttributeInt(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public long getFieldRawAttributeLong(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public ByteBuffer getFieldRawAttributeContent(int var1, int var2) throws IndexOutOfBoundsException;

    public int getFieldAttributeContentLength(int var1, int var2) throws IndexOutOfBoundsException;

    public int getMethodCount();

    public int getMethodModifiers(int var1);

    public String getMethodName(int var1);

    public MethodDescriptor getMethodDescriptor(int var1);

    public int getMethodAttributeCount(int var1) throws IndexOutOfBoundsException;

    public boolean methodAttributeNameEquals(int var1, int var2, String var3) throws IndexOutOfBoundsException;

    public int getMethodRawAttributeByte(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public int getMethodRawAttributeShort(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public int getMethodRawAttributeInt(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public long getMethodRawAttributeLong(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public ByteBuffer getMethodRawAttributeContent(int var1, int var2) throws IndexOutOfBoundsException;

    public int getMethodAttributeContentLength(int var1, int var2) throws IndexOutOfBoundsException;

    public int getAttributeCount();

    public boolean attributeNameEquals(int var1, String var2) throws IndexOutOfBoundsException;

    public int getAttributeContentLength(int var1) throws IndexOutOfBoundsException;

    public ByteBuffer getRawAttributeContent(int var1) throws IndexOutOfBoundsException;

    public int getRawAttributeByte(int var1, int var2) throws IndexOutOfBoundsException;

    public int getRawAttributeShort(int var1, int var2) throws IndexOutOfBoundsException;

    public int getRawAttributeInt(int var1, int var2) throws IndexOutOfBoundsException;

    public long getRawAttributeLong(int var1, int var2) throws IndexOutOfBoundsException;

    public void accept(DefinedTypeDefinition.Builder var1) throws ClassFormatException;

    public static ClassFile of(ClassContext ctxt, ByteBuffer orig) {
        orig.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer buffer = orig.duplicate();
        return ClassFileImpl.make(ctxt, buffer);
    }
}

