/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.qbicc.type.definition.classfile.ClassFileImpl;
import org.qbicc.type.definition.classfile.InvalidAttributeLengthException;
import org.qbicc.type.definition.classfile.InvalidByteCodeException;
import org.qbicc.type.definition.classfile.InvalidLocalVariableIndexException;
import org.qbicc.type.definition.classfile.InvalidTableSwitchRangeException;
import org.qbicc.type.definition.classfile.LineNumberTable;
import org.qbicc.type.definition.element.ExecutableElement;

final class ClassMethodInfo {
    private static final short[] NO_SHORTS = new short[0];
    private final ClassFileImpl classFile;
    private final int modifiers;
    private final int index;
    private final ByteBuffer codeAttr;
    private final int maxStack;
    private final int maxLocals;
    private final int codeOffs;
    private final int codeLen;
    private final short[] exTable;
    private final LineNumberTable lineNumberTable;
    private final short[] entryPoints;
    private final short[][] localVariables;
    private final int stackMapTableOffs;
    private final int stackMapTableLen;
    private final int visibleTypeAnnotationsOffs;
    private final int visibleTypeAnnotationsLen;
    private final int invisibleTypeAnnotationsOffs;
    private final int invisibleTypeAnnotationsLen;

    ClassMethodInfo(ClassFileImpl classFile, ExecutableElement element, int modifiers, int index, ByteBuffer codeAttr) {
        int i;
        int base;
        int i2;
        int target;
        this.classFile = classFile;
        this.modifiers = modifiers;
        this.index = index;
        this.codeAttr = codeAttr;
        int save = codeAttr.position();
        this.maxStack = codeAttr.getShort() & 0xFFFF;
        this.maxLocals = codeAttr.getShort() & 0xFFFF;
        this.codeLen = codeAttr.getInt();
        this.codeOffs = codeAttr.position();
        int lim = codeAttr.limit();
        codeAttr.limit(this.codeOffs + this.codeLen);
        ByteBuffer bc = codeAttr.slice();
        codeAttr.limit(lim);
        codeAttr.position(this.codeOffs + this.codeLen);
        BitSet enteredOnce = new BitSet(bc.capacity());
        BitSet enteredMulti = new BitSet(bc.capacity());
        enteredOnce.set(0);
        block11: while (bc.position() < bc.limit()) {
            int src = bc.position();
            int opcode = bc.get() & 0xFF;
            switch (opcode) {
                case 168: {
                    target = src + bc.getShort();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                    } else {
                        enteredOnce.set(target);
                    }
                    enteredMulti.set(bc.position());
                    break;
                }
                case 201: {
                    target = src + 5;
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                    } else {
                        enteredOnce.set(target);
                    }
                    enteredMulti.set(bc.position());
                    break;
                }
                case 167: {
                    target = src + bc.getShort();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                        continue block11;
                    }
                    enteredOnce.set(target);
                    continue block11;
                }
                case 200: {
                    target = src + bc.getInt();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                        continue block11;
                    }
                    enteredOnce.set(target);
                    continue block11;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    target = src + bc.getShort();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                        break;
                    }
                    enteredOnce.set(target);
                    break;
                }
                case 169: {
                    bc.get();
                    continue block11;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    continue block11;
                }
                case 171: {
                    ClassMethodInfo.align(bc, 4);
                    target = src + bc.getInt();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                    } else {
                        enteredOnce.set(target);
                    }
                    int cnt = bc.getInt();
                    for (i2 = 0; i2 < cnt; ++i2) {
                        bc.getInt();
                        target = src + bc.getInt();
                        if (enteredOnce.get(target)) {
                            enteredMulti.set(target);
                            continue;
                        }
                        enteredOnce.set(target);
                    }
                    continue block11;
                }
                case 170: {
                    ClassMethodInfo.align(bc, 4);
                    target = src + bc.getInt();
                    if (enteredOnce.get(target)) {
                        enteredMulti.set(target);
                    } else {
                        enteredOnce.set(target);
                    }
                    int low = bc.getInt();
                    int high = bc.getInt();
                    int cnt = high - low + 1;
                    if (cnt < 0) {
                        throw new InvalidTableSwitchRangeException();
                    }
                    for (int i3 = 0; i3 < cnt; ++i3) {
                        target = src + bc.getInt();
                        if (enteredOnce.get(target)) {
                            enteredMulti.set(target);
                            continue;
                        }
                        enteredOnce.set(target);
                    }
                    continue block11;
                }
                default: {
                    this.skipInstruction(bc, opcode);
                }
            }
            src = bc.position();
            if (enteredOnce.get(src)) {
                enteredMulti.set(src);
                continue;
            }
            enteredOnce.set(src);
        }
        int exTableLen = codeAttr.getShort() & 0xFFFF;
        short[] exTable = new short[exTableLen << 2];
        for (i2 = 0; i2 < exTableLen; ++i2) {
            base = i2 << 2;
            exTable[base] = codeAttr.getShort();
            exTable[base + 1] = codeAttr.getShort();
            short s = codeAttr.getShort();
            exTable[base + 2] = s;
            target = s;
            exTable[base + 3] = codeAttr.getShort();
            enteredMulti.set(target);
        }
        int etCnt = enteredMulti.cardinality();
        short[] entryPoints = new short[etCnt];
        int j = 0;
        int i4 = enteredMulti.nextSetBit(0);
        while (i4 >= 0) {
            entryPoints[j++] = (short)i4;
            i4 = enteredMulti.nextSetBit(i4 + 1);
        }
        this.exTable = exTable;
        int attrCnt = codeAttr.getShort() & 0xFFFF;
        int stackMapTableOffs = classFile.getMajorVersion() < 50 ? -1 : 0;
        int stackMapTableLen = 0;
        int visibleTypeAnnotationsOffs = -1;
        int visibleTypeAnnotationsLen = 0;
        int invisibleTypeAnnotationsOffs = -1;
        int invisibleTypeAnnotationsLen = 0;
        short[][] localVariables = new short[this.maxLocals][];
        int[] lvtLengths = new int[this.maxLocals];
        Arrays.fill((Object[])localVariables, NO_SHORTS);
        LineNumberTable.Builder lineNumberTable = new LineNumberTable.Builder();
        for (i = 0; i < attrCnt; ++i) {
            int nameIdx = codeAttr.getShort() & 0xFFFF;
            int len = codeAttr.getInt();
            int end = codeAttr.position() + len;
            if (classFile.utf8ConstantEquals(nameIdx, "LineNumberTable")) {
                lineNumberTable.appendTableFromAttribute(codeAttr.duplicate().limit(end).slice());
                codeAttr.position(end);
                continue;
            }
            boolean lvt = classFile.utf8ConstantEquals(nameIdx, "LocalVariableTable");
            if (lvt || classFile.utf8ConstantEquals(nameIdx, "LocalVariableTypeTable")) {
                int cnt = codeAttr.getShort() & 0xFFFF;
                if (cnt * 10 != len - 2) {
                    throw new InvalidAttributeLengthException();
                }
                for (int j2 = 0; j2 < cnt; ++j2) {
                    int startPc = codeAttr.getShort() & 0xFFFF;
                    int length = codeAttr.getShort() & 0xFFFF;
                    int varNameIdx = codeAttr.getShort() & 0xFFFF;
                    int typeIdx = codeAttr.getShort() & 0xFFFF;
                    int varIndex = codeAttr.getShort() & 0xFFFF;
                    if (varIndex >= this.maxLocals) {
                        throw new InvalidLocalVariableIndexException();
                    }
                    short[] array = localVariables[varIndex];
                    if (array.length == 0) {
                        localVariables[varIndex] = array = new short[10];
                        array[0] = (short)startPc;
                        array[1] = (short)length;
                        array[2] = (short)varNameIdx;
                        array[lvt ? 3 : 4] = (short)typeIdx;
                        lvtLengths[varIndex] = 1;
                        continue;
                    }
                    int lvtLength = lvtLengths[varIndex];
                    int idx = ClassMethodInfo.findLocalVariableEntry(array, lvtLength, startPc, length);
                    if (idx >= 0) {
                        base = idx * 5;
                        if (array[base + (lvt ? 3 : 4)] != 0 || varNameIdx != array[base + 2]) {
                            throw new InvalidLocalVariableIndexException();
                        }
                        array[base + (lvt ? 3 : 4)] = (short)typeIdx;
                        continue;
                    }
                    idx = -idx - 1;
                    base = idx * 5;
                    if (lvtLength * 5 == array.length) {
                        localVariables[varIndex] = array = Arrays.copyOf(array, (lvtLength << 1) * 5);
                    }
                    if (idx < lvtLength) {
                        System.arraycopy(array, base, array, (idx + 1) * 5, (lvtLength - idx) * 5);
                    }
                    array[base] = (short)startPc;
                    array[base + 1] = (short)length;
                    array[base + 2] = (short)varNameIdx;
                    array[base + (lvt ? 4 : 3)] = 0;
                    array[base + (lvt ? 3 : 4)] = (short)typeIdx;
                    lvtLengths[varIndex] = lvtLength + 1;
                }
                codeAttr.position(end);
                continue;
            }
            if (classFile.utf8ConstantEquals(nameIdx, "StackMapTable")) {
                stackMapTableLen = codeAttr.getShort() & 0xFFFF;
                stackMapTableOffs = codeAttr.position();
                codeAttr.position(end);
                continue;
            }
            if (classFile.utf8ConstantEquals(nameIdx, "RuntimeVisibleTypeAnnotations")) {
                visibleTypeAnnotationsLen = codeAttr.getShort() & 0xFFFF;
                visibleTypeAnnotationsOffs = codeAttr.position();
                codeAttr.position(end);
                continue;
            }
            if (classFile.utf8ConstantEquals(nameIdx, "RuntimeInvisibleTypeAnnotations")) {
                invisibleTypeAnnotationsLen = codeAttr.getShort() & 0xFFFF;
                invisibleTypeAnnotationsOffs = codeAttr.position();
                codeAttr.position(end);
                continue;
            }
            codeAttr.position(end);
        }
        for (i = 0; i < this.maxLocals; ++i) {
            if (localVariables[i].length <= lvtLengths[i] * 5) continue;
            localVariables[i] = Arrays.copyOf(localVariables[i], lvtLengths[i] * 5);
        }
        this.localVariables = localVariables;
        this.stackMapTableOffs = stackMapTableOffs;
        this.stackMapTableLen = stackMapTableLen;
        this.visibleTypeAnnotationsOffs = visibleTypeAnnotationsOffs;
        this.visibleTypeAnnotationsLen = visibleTypeAnnotationsLen;
        this.invisibleTypeAnnotationsOffs = invisibleTypeAnnotationsOffs;
        this.invisibleTypeAnnotationsLen = invisibleTypeAnnotationsLen;
        this.entryPoints = entryPoints;
        codeAttr.position(save);
        this.lineNumberTable = lineNumberTable.build();
    }

    private void skipInstruction(ByteBuffer codeAttr, int opcode) {
        switch (opcode) {
            case 171: {
                ClassMethodInfo.align(codeAttr, 4);
                codeAttr.getInt();
                int cnt = codeAttr.getInt();
                codeAttr.position(codeAttr.position() + (cnt << 3));
                break;
            }
            case 170: {
                ClassMethodInfo.align(codeAttr, 4);
                codeAttr.getInt();
                int hb = codeAttr.getInt();
                int lb = codeAttr.getInt();
                int cnt = hb - lb + 1;
                if (cnt < 0) {
                    throw new InvalidTableSwitchRangeException();
                }
                codeAttr.position(codeAttr.position() + (cnt << 2));
                break;
            }
            case 185: 
            case 186: 
            case 200: 
            case 201: {
                codeAttr.getInt();
                break;
            }
            case 197: {
                codeAttr.getShort();
                codeAttr.get();
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: {
                codeAttr.getShort();
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: 
            case 188: {
                codeAttr.get();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                break;
            }
            case 196: {
                this.skipWideInstruction(codeAttr, codeAttr.get() & 0xFF);
                break;
            }
            default: {
                throw new InvalidByteCodeException();
            }
        }
    }

    private void skipWideInstruction(ByteBuffer codeAttr, int opcode) {
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                codeAttr.getShort();
                break;
            }
            case 132: {
                codeAttr.getInt();
                break;
            }
            default: {
                throw new InvalidByteCodeException();
            }
        }
    }

    static void align(ByteBuffer buf, int align) {
        assert (Integer.bitCount(align) == 1);
        int p = buf.position();
        int mask = align - 1;
        int amt = mask - (p - 1 & mask);
        buf.position(p + amt);
    }

    static int findLocalVariableEntry(short[] array, int size, int startPc, int length) {
        if (array == null) {
            return -1;
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = array[mid * 5] & 0xFFFF;
            if (midVal < startPc) {
                low = mid + 1;
                continue;
            }
            if (midVal > startPc) {
                high = mid - 1;
                continue;
            }
            if (length != array[mid * 5 + 1]) {
                throw new InvalidLocalVariableIndexException();
            }
            return mid;
        }
        return -low - 1;
    }

    ClassFileImpl getClassFile() {
        return this.classFile;
    }

    int getModifiers() {
        return this.modifiers;
    }

    int getIndex() {
        return this.index;
    }

    ByteBuffer getCodeAttr() {
        return this.codeAttr;
    }

    int getMaxStack() {
        return this.maxStack;
    }

    int getMaxLocals() {
        return this.maxLocals;
    }

    int getEntryPointCount() {
        return this.entryPoints.length;
    }

    int getEntryPointIndex(int target) {
        int low = 0;
        int high = this.getEntryPointCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.getEntryPointTarget(mid);
            if (midVal < target) {
                low = mid + 1;
                continue;
            }
            if (midVal > target) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    int getEntryPointTarget(int index) {
        return this.entryPoints[index] & 0xFFFF;
    }

    int getLineNumber(int bci) {
        return this.lineNumberTable.getLineNumber(bci);
    }

    int getLocalVarEntryCount(int varIdx) {
        return this.localVariables[varIdx].length / 5;
    }

    int getLocalVarStartPc(int varIdx, int entryIdx) {
        return this.localVariables[varIdx][entryIdx * 5] & 0xFFFF;
    }

    int getLocalVarLength(int varIdx, int entryIdx) {
        return this.localVariables[varIdx][entryIdx * 5 + 1] & 0xFFFF;
    }

    int getLocalVarNameIndex(int varIdx, int entryIdx) {
        return this.localVariables[varIdx][entryIdx * 5 + 2] & 0xFFFF;
    }

    int getLocalVarDescriptorIndex(int varIdx, int entryIdx) {
        return this.localVariables[varIdx][entryIdx * 5 + 3] & 0xFFFF;
    }

    int getLocalVarSignatureIndex(int varIdx, int entryIdx) {
        return this.localVariables[varIdx][entryIdx * 5 + 4] & 0xFFFF;
    }

    int getLocalVarEntryIndex(int varIdx, int bci) {
        int low = 0;
        int high = this.getLocalVarEntryCount(varIdx) - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.getLocalVarStartPc(varIdx, mid);
            if (midVal + this.getLocalVarLength(varIdx, mid) <= bci) {
                low = mid + 1;
                continue;
            }
            if (midVal > bci) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    int getCodeOffs() {
        return this.codeOffs;
    }

    int getCodeLen() {
        return this.codeLen;
    }

    int getExTableLen() {
        return this.exTable.length >> 2;
    }

    int getExTableEntryStartPc(int entry) {
        return this.exTable[entry << 2] & 0xFFFF;
    }

    int getExTableEntryEndPc(int entry) {
        return this.exTable[(entry << 2) + 1] & 0xFFFF;
    }

    int getExTableEntryHandlerPc(int entry) {
        return this.exTable[(entry << 2) + 2] & 0xFFFF;
    }

    int getExTableEntryTypeIdx(int entry) {
        return this.exTable[(entry << 2) + 3] & 0xFFFF;
    }

    int getStackMapTableOffs() {
        return this.stackMapTableOffs;
    }

    int getStackMapTableLen() {
        return this.stackMapTableLen;
    }

    int getVisibleTypeAnnotationsOffs() {
        return this.visibleTypeAnnotationsOffs;
    }

    int getVisibleTypeAnnotationsLen() {
        return this.visibleTypeAnnotationsLen;
    }

    int getInvisibleTypeAnnotationsOffs() {
        return this.invisibleTypeAnnotationsOffs;
    }

    int getInvisibleTypeAnnotationsLen() {
        return this.invisibleTypeAnnotationsLen;
    }
}

