/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.qbicc.type.definition.classfile.ClassFileImpl;
import org.qbicc.type.definition.classfile.InvalidAttributeLengthException;

final class LineNumberTable {
    private final short[] lineNumbers;

    public LineNumberTable(short[] lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    private static int findLineNumber(short[] table, int size, int bci) {
        if (table == null) {
            return -1;
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = table[mid << 1] & 0xFFFF;
            if (midVal < bci) {
                low = mid + 1;
                continue;
            }
            if (midVal > bci) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    int getLineNumber(int bci) {
        int low = 0;
        int high = (this.lineNumbers.length >>> 1) - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.lineNumbers[mid << 1] & 0xFFFF;
            if (midVal < bci) {
                low = mid + 1;
                continue;
            }
            if (midVal > bci) {
                high = mid - 1;
                continue;
            }
            return this.lineNumbers[(mid << 1) + 1] & 0xFFFF;
        }
        if (low == 0) {
            return 1;
        }
        return this.lineNumbers[(low - 1 << 1) + 1] & 0xFFFF;
    }

    int getMinimumLineNumber() {
        if (this.lineNumbers.length != 0) {
            int minimumLineNumber = Integer.MAX_VALUE;
            for (int i = 1; i < this.lineNumbers.length; i += 2) {
                minimumLineNumber = Math.min(minimumLineNumber, this.lineNumbers[i] & 0xFFFF);
            }
            return minimumLineNumber;
        }
        return 1;
    }

    int getMaximumLineNumber() {
        if (this.lineNumbers.length != 0) {
            int maximumLineNumber = 1;
            for (int i = 1; i < this.lineNumbers.length; i += 2) {
                maximumLineNumber = Math.max(maximumLineNumber, this.lineNumbers[i] & 0xFFFF);
            }
            return maximumLineNumber;
        }
        return 1;
    }

    static LineNumberTable createForCodeAttribute(ClassFileImpl classFile, ByteBuffer codeAttr) {
        codeAttr.getShort();
        codeAttr.getShort();
        int codeLen = codeAttr.getInt();
        codeAttr.position(codeAttr.position() + codeLen);
        int exTableLen = codeAttr.getShort() & 0xFFFF;
        codeAttr.position(codeAttr.position() + exTableLen * 8);
        int attrCnt = codeAttr.getShort() & 0xFFFF;
        Builder b = new Builder();
        for (int i = 0; i < attrCnt; ++i) {
            int nameIdx = codeAttr.getShort() & 0xFFFF;
            int len = codeAttr.getInt();
            if (classFile.utf8ConstantEquals(nameIdx, "LineNumberTable")) {
                b.appendTableFromAttribute(codeAttr.duplicate().limit(codeAttr.position() + len).slice());
            }
            codeAttr.position(codeAttr.position() + len);
        }
        return b.build();
    }

    static final class Builder {
        private static final short[] NO_SHORTS = new short[0];
        private short[] lineNumberTable = NO_SHORTS;
        private int lineNumberTableLen;

        Builder() {
        }

        Builder appendTableFromAttribute(ByteBuffer lntAttr) {
            int cnt = lntAttr.getShort() & 0xFFFF;
            if (cnt << 2 != lntAttr.limit() - 2) {
                throw new InvalidAttributeLengthException();
            }
            if ((this.lineNumberTable.length >>> 1) - this.lineNumberTableLen < cnt) {
                this.lineNumberTable = Arrays.copyOf(this.lineNumberTable, this.lineNumberTableLen + (cnt << 1));
            }
            for (int j = 0; j < cnt; ++j) {
                int startPc = lntAttr.getShort() & 0xFFFF;
                int lineNumber = lntAttr.getShort() & 0xFFFF;
                if (this.lineNumberTable.length == 0) {
                    this.lineNumberTable = new short[cnt];
                    this.lineNumberTable[0] = (short)startPc;
                    this.lineNumberTable[1] = (short)lineNumber;
                    continue;
                }
                int idx = LineNumberTable.findLineNumber(this.lineNumberTable, this.lineNumberTableLen, startPc);
                if (idx >= 0) continue;
                if ((idx = -idx - 1) < this.lineNumberTableLen) {
                    System.arraycopy(this.lineNumberTable, idx << 1, this.lineNumberTable, 1 + (idx << 1), this.lineNumberTableLen - idx << 1);
                }
                this.lineNumberTable[idx << 1] = (short)startPc;
                this.lineNumberTable[(idx << 1) + 1] = (short)lineNumber;
                ++this.lineNumberTableLen;
            }
            return this;
        }

        LineNumberTable build() {
            short[] lineNumbers = this.lineNumberTableLen << 1 == this.lineNumberTable.length ? this.lineNumberTable : Arrays.copyOf(this.lineNumberTable, this.lineNumberTableLen << 1);
            return new LineNumberTable(lineNumbers);
        }
    }
}

