/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.definition.element.BasicElement;

public abstract class AnnotatedElement
extends BasicElement {
    private final List<Annotation> visibleAnnotations;
    private final List<Annotation> invisibleAnnotations;

    AnnotatedElement() {
        this.visibleAnnotations = null;
        this.invisibleAnnotations = null;
    }

    AnnotatedElement(BuilderImpl builder) {
        super(builder);
        this.visibleAnnotations = builder.visibleAnnotations;
        this.invisibleAnnotations = builder.invisibleAnnotations;
    }

    public List<Annotation> getVisibleAnnotations() {
        return this.visibleAnnotations;
    }

    public List<Annotation> getInvisibleAnnotations() {
        return this.invisibleAnnotations;
    }

    static abstract class BuilderImpl
    extends BasicElement.BuilderImpl
    implements Builder {
        List<Annotation> visibleAnnotations = List.of();
        List<Annotation> invisibleAnnotations = List.of();

        BuilderImpl(int index) {
            super(index);
        }

        BuilderImpl(AnnotatedElement original) {
            super(original);
            this.visibleAnnotations = original.visibleAnnotations;
            this.invisibleAnnotations = original.invisibleAnnotations;
        }

        @Override
        public void addVisibleAnnotations(List<Annotation> annotations) {
            Assert.checkNotNullParam((String)"annotations", annotations);
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = annotations;
            } else if (!annotations.isEmpty()) {
                ArrayList<Annotation> tmp = new ArrayList<Annotation>();
                tmp.addAll(this.visibleAnnotations);
                tmp.addAll(annotations);
                this.visibleAnnotations = List.copyOf(tmp);
            }
        }

        @Override
        public void addInvisibleAnnotations(List<Annotation> annotations) {
            Assert.checkNotNullParam((String)"annotations", annotations);
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = annotations;
            } else if (!annotations.isEmpty()) {
                ArrayList<Annotation> tmp = new ArrayList<Annotation>();
                tmp.addAll(this.invisibleAnnotations);
                tmp.addAll(annotations);
                this.invisibleAnnotations = List.copyOf(tmp);
            }
        }

        @Override
        public abstract AnnotatedElement build();
    }

    public static interface Builder
    extends BasicElement.Builder {
        public void addVisibleAnnotations(List<Annotation> var1);

        public void addInvisibleAnnotations(List<Annotation> var1);

        @Override
        public AnnotatedElement build();

        public static interface Delegating
        extends BasicElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void addVisibleAnnotations(List<Annotation> annotations) {
                this.getDelegate().addVisibleAnnotations(annotations);
            }

            @Override
            default public void addInvisibleAnnotations(List<Annotation> annotations) {
                this.getDelegate().addInvisibleAnnotations(annotations);
            }

            @Override
            default public AnnotatedElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

