/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.function.Function;
import org.qbicc.pointer.FunctionPointer;
import org.qbicc.type.FunctionType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.NamedElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.util.ResolutionUtil;

public final class FunctionElement
extends InvokableElement
implements NamedElement {
    private static final VarHandle pointerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "pointer", VarHandle.class, FunctionElement.class, FunctionPointer.class);
    private volatile FunctionPointer pointer;
    private final String name;

    FunctionElement(BuilderImpl builder) {
        super(builder);
        Assert.checkNotNullParam((String)"builder.type", (Object)builder.type);
        this.name = (String)Assert.checkNotNullParam((String)"builder.name", (Object)builder.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FunctionType getType() {
        return (FunctionType)super.getType();
    }

    @Override
    FunctionType computeType() {
        return ResolutionUtil.resolveFunctionType(this.getEnclosingType(), this, this.getDescriptor(), this.getSignature());
    }

    public FunctionPointer getOrCreatePointer(Function<FunctionElement, FunctionPointer> factory) {
        FunctionPointer appearing;
        FunctionPointer pointer = this.pointer;
        if (pointer == null && (appearing = pointerHandle.compareAndExchange(this, null, pointer = factory.apply(this))) != null) {
            pointer = appearing;
        }
        return pointer;
    }

    @Override
    public <T, R> R accept(ElementVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public String toString() {
        return "function " + this.getName();
    }

    public static Builder builder(String name, MethodDescriptor descriptor, int index) {
        return new BuilderImpl(name, descriptor, index);
    }

    static final class BuilderImpl
    extends InvokableElement.BuilderImpl
    implements Builder {
        private final String name;

        BuilderImpl(String name, MethodDescriptor descriptor, int index) {
            super(descriptor, index);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FunctionElement build() {
            return new FunctionElement(this);
        }

        @Override
        public void setType(FunctionType type) {
            super.setType((FunctionType)Assert.checkNotNullParam((String)"type", (Object)type));
        }

        @Override
        public void addVisibleAnnotations(List<Annotation> annotations) {
            throw new UnsupportedOperationException("Functions do not support annotations");
        }

        @Override
        public void addInvisibleAnnotations(List<Annotation> annotations) {
            throw new UnsupportedOperationException("Functions do not support annotations");
        }

        @Override
        public void setVisibleTypeAnnotations(TypeAnnotationList returnVisibleTypeAnnotations) {
            throw new UnsupportedOperationException("Functions do not support annotations");
        }

        @Override
        public void setInvisibleTypeAnnotations(TypeAnnotationList returnInvisibleTypeAnnotations) {
            throw new UnsupportedOperationException("Functions do not support annotations");
        }
    }

    public static interface Builder
    extends InvokableElement.Builder,
    NamedElement.Builder {
        @Override
        public FunctionElement build();

        public void setType(FunctionType var1);

        @Override
        public void addVisibleAnnotations(List<Annotation> var1);

        @Override
        public void addInvisibleAnnotations(List<Annotation> var1);

        @Override
        public void setVisibleTypeAnnotations(TypeAnnotationList var1);

        @Override
        public void setInvisibleTypeAnnotations(TypeAnnotationList var1);

        public static interface Delegating
        extends InvokableElement.Builder.Delegating,
        NamedElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setType(FunctionType type) {
                this.getDelegate().setType(type);
            }

            @Override
            default public FunctionElement build() {
                return this.getDelegate().build();
            }

            @Override
            default public void addVisibleAnnotations(List<Annotation> annotations) {
                this.getDelegate().addVisibleAnnotations(annotations);
            }

            @Override
            default public void addInvisibleAnnotations(List<Annotation> annotations) {
                this.getDelegate().addInvisibleAnnotations(annotations);
            }

            @Override
            default public void setVisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setVisibleTypeAnnotations(annotations);
            }

            @Override
            default public void setInvisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setInvisibleTypeAnnotations(annotations);
            }
        }
    }
}

