/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.function.Function;
import org.qbicc.context.ClassContext;
import org.qbicc.pointer.InitializerPointer;
import org.qbicc.type.StaticMethodType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.element.BasicElement;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.generic.MethodSignature;

public final class InitializerElement
extends BasicElement
implements ExecutableElement {
    private static final VarHandle pointerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "pointer", VarHandle.class, InitializerElement.class, InitializerPointer.class);
    final MethodBodyFactory methodBodyFactory;
    final int methodBodyFactoryIndex;
    volatile MethodBody previousMethodBody;
    volatile MethodBody methodBody;
    final int minimumLineNumber;
    final int maximumLineNumber;
    boolean inProgress;
    volatile int lowerIndex;
    private volatile InitializerPointer pointer;

    InitializerElement(BuilderImpl builder) {
        super(builder);
        this.methodBodyFactory = builder.methodBodyFactory;
        this.methodBodyFactoryIndex = builder.methodBodyFactoryIndex;
        this.minimumLineNumber = builder.minimumLineNumber;
        this.maximumLineNumber = builder.maximumLineNumber;
    }

    @Override
    public boolean hasMethodBodyFactory() {
        return this.methodBodyFactory != null;
    }

    @Override
    public boolean hasMethodBody() {
        return this.methodBody != null;
    }

    @Override
    public MethodBody getPreviousMethodBody() {
        return this.previousMethodBody;
    }

    @Override
    public MethodBody getMethodBody() {
        MethodBody methodBody = this.methodBody;
        if (methodBody == null) {
            throw new IllegalStateException("No method body is present on this element");
        }
        return methodBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryCreateMethodBody() {
        MethodBody methodBody = this.methodBody;
        if (methodBody == null) {
            MethodBodyFactory factory = this.methodBodyFactory;
            if (factory != null) {
                InitializerElement initializerElement = this;
                synchronized (initializerElement) {
                    methodBody = this.methodBody;
                    if (methodBody == null) {
                        if (this.inProgress) {
                            return true;
                        }
                        this.inProgress = true;
                        try {
                            this.methodBody = this.previousMethodBody = factory.createMethodBody(this.methodBodyFactoryIndex, this);
                        }
                        finally {
                            this.inProgress = false;
                        }
                    }
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void replaceMethodBody(MethodBody replacement) {
        MethodBody existing = this.methodBody;
        if (existing != null) {
            this.previousMethodBody = existing;
        }
        this.methodBody = replacement;
    }

    @Override
    public StaticMethodType getType() {
        ClassContext classContext = this.getEnclosingType().getContext();
        TypeSystem ts = classContext.getTypeSystem();
        return ts.getStaticMethodType(ts.getVoidType(), List.of());
    }

    @Override
    public MethodDescriptor getDescriptor() {
        return MethodDescriptor.VOID_METHOD_DESCRIPTOR;
    }

    @Override
    public MethodSignature getSignature() {
        return MethodSignature.VOID_METHOD_SIGNATURE;
    }

    @Override
    public int getMinimumLineNumber() {
        return this.minimumLineNumber;
    }

    @Override
    public int getMaximumLineNumber() {
        return this.maximumLineNumber;
    }

    public int getLowerIndex() {
        return this.lowerIndex;
    }

    public void setLowerIndex(int lowerIndex) {
        this.lowerIndex = lowerIndex;
    }

    public InitializerPointer getOrCreatePointer(Function<InitializerElement, InitializerPointer> factory) {
        InitializerPointer appearing;
        InitializerPointer pointer = this.pointer;
        if (pointer == null && (appearing = pointerHandle.compareAndExchange(this, null, pointer = factory.apply(this))) != null) {
            pointer = appearing;
        }
        return pointer;
    }

    @Override
    public <T, R> R accept(ElementVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String toString() {
        return "Initializer(" + this.getEnclosingType().getInternalName() + ")";
    }

    static final class BuilderImpl
    extends BasicElement.BuilderImpl
    implements Builder {
        MethodBodyFactory methodBodyFactory;
        int methodBodyFactoryIndex;
        int minimumLineNumber = 1;
        int maximumLineNumber = 1;

        BuilderImpl() {
            super(0);
        }

        @Override
        public void setMethodBodyFactory(MethodBodyFactory factory, int index) {
            this.methodBodyFactory = (MethodBodyFactory)Assert.checkNotNullParam((String)"factory", (Object)factory);
            this.methodBodyFactoryIndex = index;
        }

        @Override
        public void setMinimumLineNumber(int minimumLineNumber) {
            this.minimumLineNumber = minimumLineNumber;
        }

        @Override
        public void setMaximumLineNumber(int maximumLineNumber) {
            this.maximumLineNumber = maximumLineNumber;
        }

        @Override
        public InitializerElement build() {
            return new InitializerElement(this);
        }
    }

    public static interface Builder
    extends BasicElement.Builder,
    ExecutableElement.Builder {
        @Override
        public void setMethodBodyFactory(MethodBodyFactory var1, int var2);

        public void setMinimumLineNumber(int var1);

        public void setMaximumLineNumber(int var1);

        @Override
        public InitializerElement build();

        public static interface Delegating
        extends BasicElement.Builder.Delegating,
        ExecutableElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setMinimumLineNumber(int minimumLineNumber) {
                this.getDelegate().setMinimumLineNumber(minimumLineNumber);
            }

            @Override
            default public void setMaximumLineNumber(int maximumLineNumber) {
                this.getDelegate().setMaximumLineNumber(maximumLineNumber);
            }

            @Override
            default public void setMethodBodyFactory(MethodBodyFactory factory, int index) {
                this.getDelegate().setMethodBodyFactory(factory, index);
            }

            @Override
            default public InitializerElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

