/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Function;
import org.qbicc.graph.literal.Literal;
import org.qbicc.pointer.StaticFieldPointer;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;

public final class StaticFieldElement
extends FieldElement {
    private static final VarHandle pointerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "pointer", VarHandle.class, StaticFieldElement.class, StaticFieldPointer.class);
    private final Literal initialValue;
    private final InitializerElement runTimeInitializer;
    private volatile StaticFieldPointer pointer;

    StaticFieldElement(FieldElement.BuilderImpl builder) {
        super(builder);
        this.initialValue = builder.initialValue;
        this.runTimeInitializer = builder.runTimeInitializer;
    }

    @Override
    public boolean isReallyFinal() {
        return this.runTimeInitializer == null && super.isReallyFinal();
    }

    public Literal getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void clearModifierFlags(int flags) {
        if ((flags & 8) != 0) {
            throw new IllegalArgumentException("Cannot make a static element into an instance element");
        }
        super.clearModifierFlags(flags);
    }

    public InitializerElement getRunTimeInitializer() {
        return this.runTimeInitializer;
    }

    public StaticFieldPointer getPointer() {
        return StaticFieldPointer.of(this);
    }

    public StaticFieldPointer getOrCreatePointer(Function<StaticFieldElement, StaticFieldPointer> factory) {
        StaticFieldPointer pointer = this.pointer;
        if (pointer == null) {
            if (!this.isStatic()) {
                throw new IllegalArgumentException("Static pointer for instance field");
            }
            pointer = factory.apply(this);
            StaticFieldPointer appearing = pointerHandle.compareAndExchange(this, null, pointer);
            if (appearing != null) {
                pointer = appearing;
            }
        }
        return pointer;
    }
}

