/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import org.qbicc.context.ClassContext;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.element.AnnotatedElement;
import org.qbicc.type.definition.element.NamedElement;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public abstract class VariableElement
extends AnnotatedElement
implements NamedElement {
    private final String name;
    private final TypeDescriptor typeDescriptor;
    private final TypeSignature typeSignature;
    private final TypeAnnotationList visibleTypeAnnotations;
    private final TypeAnnotationList invisibleTypeAnnotations;
    private final TypeParameterContext typeParameterContext;
    private final int minimumAlignment;
    private volatile ValueType type;
    private volatile long offset = -1L;

    VariableElement(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.typeDescriptor = (TypeDescriptor)Assert.checkNotNullParam((String)"builder.typeDescriptor", (Object)builder.typeDescriptor);
        this.typeSignature = (TypeSignature)Assert.checkNotNullParam((String)"builder.typeSignature", (Object)builder.typeSignature);
        this.visibleTypeAnnotations = builder.visibleTypeAnnotations;
        this.invisibleTypeAnnotations = builder.invisibleTypeAnnotations;
        this.typeParameterContext = (TypeParameterContext)Assert.checkNotNullParam((String)"builder.typeParameterContext", (Object)builder.typeParameterContext);
        this.minimumAlignment = builder.minimumAlignment;
        ValueType type = builder.type;
        if (type != null) {
            this.type = type;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public TypeAnnotationList getVisibleTypeAnnotations() {
        return this.visibleTypeAnnotations;
    }

    public TypeAnnotationList getInvisibleTypeAnnotations() {
        return this.invisibleTypeAnnotations;
    }

    public ValueType getType() {
        ClassContext classContext = this.getEnclosingType().getContext();
        ValueType type = this.type;
        if (type == null) {
            type = this.resolveTypeDescriptor(classContext, this.typeParameterContext);
            if (type instanceof ObjectType) {
                type = ((ObjectType)type).getReference();
            }
            this.type = type;
        }
        return type;
    }

    public int getMinimumAlignment() {
        return this.minimumAlignment;
    }

    public <T extends ValueType> T getType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getType()));
    }

    ValueType resolveTypeDescriptor(ClassContext classContext, TypeParameterContext paramCtxt) {
        return classContext.resolveTypeFromDescriptor(this.getTypeDescriptor(), paramCtxt, this.getTypeSignature());
    }

    public boolean isFinal() {
        return this.hasAllModifiersOf(16);
    }

    public boolean hasClass2Type() {
        return this.getTypeDescriptor().isClass2();
    }

    public long getOffset() {
        long offset = this.offset;
        if (offset == -1L) {
            throw new IllegalStateException();
        }
        return offset;
    }

    public void setOffset(long offset) {
        if (this.offset != -1L && this.offset != offset) {
            throw new IllegalStateException("Value of offset was changed to " + offset + " from a value of " + this.offset + " for " + this);
        }
        this.offset = offset;
    }

    static abstract class BuilderImpl
    extends AnnotatedElement.BuilderImpl
    implements Builder {
        private final String name;
        private final TypeDescriptor typeDescriptor;
        private TypeSignature typeSignature;
        private TypeAnnotationList visibleTypeAnnotations = TypeAnnotationList.empty();
        private TypeAnnotationList invisibleTypeAnnotations = TypeAnnotationList.empty();
        private TypeParameterContext typeParameterContext;
        private ValueType type;
        private int minimumAlignment = 1;

        BuilderImpl(String name, TypeDescriptor typeDescriptor, int index) {
            super(index);
            this.name = name;
            this.typeDescriptor = typeDescriptor;
        }

        BuilderImpl(VariableElement original) {
            super(original);
            this.name = original.name;
            this.typeDescriptor = original.typeDescriptor;
            this.typeSignature = original.typeSignature;
            this.visibleTypeAnnotations = original.visibleTypeAnnotations;
            this.invisibleTypeAnnotations = original.invisibleTypeAnnotations;
            this.typeParameterContext = original.typeParameterContext;
            this.type = original.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeDescriptor getDescriptor() {
            return this.typeDescriptor;
        }

        @Override
        public void setSignature(TypeSignature typeSignature) {
            this.typeSignature = (TypeSignature)Assert.checkNotNullParam((String)"typeSignature", (Object)typeSignature);
        }

        @Override
        public void setVisibleTypeAnnotations(TypeAnnotationList annotations) {
            this.visibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"annotations", (Object)annotations);
        }

        @Override
        public void setInvisibleTypeAnnotations(TypeAnnotationList annotations) {
            this.invisibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"annotations", (Object)annotations);
        }

        @Override
        public void setTypeParameterContext(TypeParameterContext typeParameterContext) {
            this.typeParameterContext = typeParameterContext;
        }

        @Override
        public void setType(ValueType type) {
            this.type = type;
        }

        @Override
        public void setMinimumAlignment(int minimumAlignment) {
            Assert.checkMinimumParameter((String)"minimumAlignment", (int)1, (int)minimumAlignment);
            this.minimumAlignment = minimumAlignment;
        }

        @Override
        public abstract VariableElement build();
    }

    public static interface Builder
    extends AnnotatedElement.Builder,
    NamedElement.Builder {
        public TypeDescriptor getDescriptor();

        public void setSignature(TypeSignature var1);

        public void setVisibleTypeAnnotations(TypeAnnotationList var1);

        public void setInvisibleTypeAnnotations(TypeAnnotationList var1);

        public void setTypeParameterContext(TypeParameterContext var1);

        public void setType(ValueType var1);

        public void setMinimumAlignment(int var1);

        @Override
        public VariableElement build();

        public static interface Delegating
        extends AnnotatedElement.Builder.Delegating,
        NamedElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public TypeDescriptor getDescriptor() {
                return this.getDelegate().getDescriptor();
            }

            @Override
            default public void setSignature(TypeSignature typeSignature) {
                this.getDelegate().setSignature(typeSignature);
            }

            @Override
            default public void setVisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setVisibleTypeAnnotations(annotations);
            }

            @Override
            default public void setInvisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setInvisibleTypeAnnotations(annotations);
            }

            @Override
            default public void setTypeParameterContext(TypeParameterContext typeParameterContext) {
                this.getDelegate().setTypeParameterContext(typeParameterContext);
            }

            @Override
            default public void setType(ValueType type) {
                this.getDelegate().setType(type);
            }

            @Override
            default public void setMinimumAlignment(int minimumAlignment) {
                this.getDelegate().setMinimumAlignment(minimumAlignment);
            }

            @Override
            default public VariableElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

