/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.nio.ByteBuffer;
import org.qbicc.context.ClassContext;
import org.qbicc.type.descriptor.Cache;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class ArrayTypeDescriptor
extends TypeDescriptor {
    private final TypeDescriptor elementTypeDescriptor;

    ArrayTypeDescriptor(TypeDescriptor elementTypeDescriptor) {
        super(elementTypeDescriptor.hashCode() * 19 + ArrayTypeDescriptor.class.hashCode());
        this.elementTypeDescriptor = elementTypeDescriptor;
    }

    public TypeDescriptor getElementTypeDescriptor() {
        return this.elementTypeDescriptor;
    }

    @Override
    public boolean equals(TypeDescriptor other) {
        return other instanceof ArrayTypeDescriptor && this.equals((ArrayTypeDescriptor)other);
    }

    public boolean equals(ArrayTypeDescriptor other) {
        return super.equals(other) && this.elementTypeDescriptor.equals(other.elementTypeDescriptor);
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        return this.elementTypeDescriptor.toString(target.append('['));
    }

    public static ArrayTypeDescriptor parse(ClassContext classContext, ByteBuffer buf) {
        int i = ArrayTypeDescriptor.next(buf);
        if (i != 91) {
            throw ArrayTypeDescriptor.parseError();
        }
        return ArrayTypeDescriptor.of(classContext, TypeDescriptor.parse(classContext, buf));
    }

    public static ArrayTypeDescriptor of(ClassContext classContext, TypeDescriptor elementTypeDescriptor) {
        return Cache.get(classContext).getArrayTypeDescriptor(elementTypeDescriptor);
    }
}

