/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.nio.ByteBuffer;
import org.qbicc.context.ClassContext;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public abstract class Descriptor {
    private final int hashCode;

    Descriptor(int hashCode) {
        this.hashCode = hashCode;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Descriptor && this.equals((Descriptor)obj);
    }

    public boolean equals(Descriptor other) {
        return this == other || other != null && this.hashCode == other.hashCode;
    }

    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public abstract StringBuilder toString(StringBuilder var1);

    public final int hashCode() {
        return this.hashCode;
    }

    public static Descriptor parse(ClassContext classContext, ByteBuffer buf) {
        int i = Descriptor.peek(buf);
        if (i == 40) {
            return MethodDescriptor.parse(classContext, buf);
        }
        return TypeDescriptor.parse(classContext, buf);
    }

    static int next(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    static int peek(ByteBuffer buf) {
        return buf.get(buf.position()) & 0xFF;
    }

    static void expect(ByteBuffer buf, int val) {
        if (Descriptor.next(buf) != val) {
            throw Descriptor.parseError();
        }
    }

    static int codePoint(ByteBuffer buf) {
        int a = Descriptor.next(buf);
        if (a < 128) {
            return a;
        }
        if (a < 192) {
            throw Descriptor.parseError();
        }
        if (a < 224) {
            int b = Descriptor.next(buf);
            if (b < 128 || 191 < b) {
                throw Descriptor.parseError();
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = Descriptor.next(buf);
            if (b < 128 || 191 < b) {
                throw Descriptor.parseError();
            }
            int c = Descriptor.next(buf);
            if (c < 128 || 191 < c) {
                throw Descriptor.parseError();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw Descriptor.parseError();
    }

    static IllegalArgumentException parseError() {
        return new IllegalArgumentException("Invalid descriptor string");
    }
}

