/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.qbicc.context.ClassContext;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.Cache;
import org.qbicc.type.descriptor.Descriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class MethodDescriptor
extends Descriptor {
    private final List<TypeDescriptor> parameterTypes;
    private final TypeDescriptor returnType;
    public static final MethodDescriptor VOID_METHOD_DESCRIPTOR = new MethodDescriptor(List.of(), BaseTypeDescriptor.V);

    MethodDescriptor(List<TypeDescriptor> parameterTypes, TypeDescriptor returnType) {
        super(Objects.hash(MethodDescriptor.class, parameterTypes, returnType));
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public List<TypeDescriptor> getParameterTypes() {
        return this.parameterTypes;
    }

    public TypeDescriptor getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean equals(Descriptor other) {
        return other instanceof MethodDescriptor && this.equals((MethodDescriptor)other);
    }

    public boolean equals(MethodDescriptor other) {
        return super.equals(other) && this.returnType.equals(other.returnType) && this.parameterTypes.equals(other.parameterTypes);
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        target.append('(');
        for (TypeDescriptor parameterType : this.parameterTypes) {
            parameterType.toString(target);
        }
        return this.returnType.toString(target.append(')'));
    }

    public static MethodDescriptor parse(ClassContext classContext, ByteBuffer buf) {
        List<TypeDescriptor> paramTypes;
        if (MethodDescriptor.next(buf) != 40) {
            throw MethodDescriptor.parseError();
        }
        if (MethodDescriptor.peek(buf) != 41) {
            TypeDescriptor a = TypeDescriptor.parse(classContext, buf);
            if (MethodDescriptor.peek(buf) != 41) {
                TypeDescriptor b = TypeDescriptor.parse(classContext, buf);
                if (MethodDescriptor.peek(buf) != 41) {
                    TypeDescriptor c = TypeDescriptor.parse(classContext, buf);
                    if (MethodDescriptor.peek(buf) != 41) {
                        TypeDescriptor d = TypeDescriptor.parse(classContext, buf);
                        if (MethodDescriptor.peek(buf) != 41) {
                            TypeDescriptor e = TypeDescriptor.parse(classContext, buf);
                            if (MethodDescriptor.peek(buf) != 41) {
                                TypeDescriptor f = TypeDescriptor.parse(classContext, buf);
                                if (MethodDescriptor.peek(buf) != 41) {
                                    paramTypes = new ArrayList<TypeDescriptor>();
                                    Collections.addAll(paramTypes, a, b, c, d, e, f);
                                    paramTypes.add(TypeDescriptor.parse(classContext, buf));
                                    while (MethodDescriptor.peek(buf) != 41) {
                                        paramTypes.add(TypeDescriptor.parse(classContext, buf));
                                    }
                                    paramTypes = List.copyOf(paramTypes);
                                } else {
                                    paramTypes = List.of(a, b, c, d, e, f);
                                }
                            } else {
                                paramTypes = List.of(a, b, c, d, e);
                            }
                        } else {
                            paramTypes = List.of(a, b, c, d);
                        }
                    } else {
                        paramTypes = List.of(a, b, c);
                    }
                } else {
                    paramTypes = List.of(a, b);
                }
            } else {
                paramTypes = List.of(a);
            }
        } else {
            paramTypes = List.of();
        }
        MethodDescriptor.expect(buf, 41);
        return Cache.get(classContext).getMethodDescriptor(paramTypes, TypeDescriptor.parse(classContext, buf));
    }

    public static MethodDescriptor synthesize(ClassContext classContext, TypeDescriptor returnType, List<TypeDescriptor> paramTypes) {
        return Cache.get(classContext).getMethodDescriptor(paramTypes, returnType);
    }
}

