/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Iterables;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.generic.TypeSignature;

public final class BaseTypeSignature
extends TypeSignature {
    public static final BaseTypeSignature B = new BaseTypeSignature("B", "byte");
    public static final BaseTypeSignature C = new BaseTypeSignature("C", "char");
    public static final BaseTypeSignature D = new BaseTypeSignature("D", "double");
    public static final BaseTypeSignature F = new BaseTypeSignature("F", "float");
    public static final BaseTypeSignature I = new BaseTypeSignature("I", "int");
    public static final BaseTypeSignature J = new BaseTypeSignature("J", "long");
    public static final BaseTypeSignature S = new BaseTypeSignature("S", "short");
    public static final BaseTypeSignature Z = new BaseTypeSignature("Z", "long");
    public static final BaseTypeSignature V = new BaseTypeSignature("V", "void");
    private final String shortName;
    private final String fullName;

    private BaseTypeSignature(String shortName, String fullName) {
        this(shortName, fullName, (ImmutableMap<ClassTypeDescriptor, Annotation>)Iterables.iMap());
    }

    private BaseTypeSignature(String shortName, String fullName, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        super(Objects.hash(BaseTypeSignature.class, shortName, fullName), annotations);
        this.shortName = shortName;
        this.fullName = fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getCodePoint() {
        return this.shortName.charAt(0);
    }

    @Override
    public boolean equals(TypeSignature other) {
        return other instanceof BaseTypeSignature && this.equals((BaseTypeSignature)other);
    }

    @Override
    public BaseTypeDescriptor asDescriptor(ClassContext classContext) {
        return (BaseTypeDescriptor)super.asDescriptor(classContext);
    }

    @Override
    BaseTypeDescriptor makeDescriptor(ClassContext classContext) {
        return BaseTypeDescriptor.forChar(this.shortName.charAt(0));
    }

    public boolean equals(BaseTypeSignature other) {
        return this == other;
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        return target.append(this.shortName);
    }

    @Override
    public BaseTypeSignature withAnnotation(Annotation annotation) {
        return (BaseTypeSignature)super.withAnnotation(annotation);
    }

    @Override
    public BaseTypeSignature withAnnotations(Set<Annotation> set) {
        return (BaseTypeSignature)super.withAnnotations(set);
    }

    @Override
    public BaseTypeSignature withOnlyAnnotations(Set<Annotation> set) {
        return (BaseTypeSignature)super.withOnlyAnnotations(set);
    }

    @Override
    public BaseTypeSignature withoutAnnotation(Annotation annotation) {
        return (BaseTypeSignature)super.withoutAnnotation(annotation);
    }

    @Override
    public BaseTypeSignature withoutAnnotation(ClassTypeDescriptor descriptor) {
        return (BaseTypeSignature)super.withoutAnnotation(descriptor);
    }

    @Override
    BaseTypeSignature replacingAnnotationMap(ImmutableMap<ClassTypeDescriptor, Annotation> newMap) {
        return new BaseTypeSignature(this.shortName, this.fullName, newMap);
    }

    static BaseTypeSignature parse(ByteBuffer buf) {
        return BaseTypeSignature.forChar(BaseTypeSignature.next(buf));
    }

    static BaseTypeSignature forChar(int i) {
        return switch (i) {
            case 66 -> B;
            case 67 -> C;
            case 68 -> D;
            case 70 -> F;
            case 73 -> I;
            case 74 -> J;
            case 83 -> S;
            case 86 -> V;
            case 90 -> Z;
            default -> throw BaseTypeSignature.parseError();
        };
    }
}

