/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.qbicc.context.ClassContext;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ParameterizedSignature;
import org.qbicc.type.generic.ThrowsSignature;
import org.qbicc.type.generic.TypeParameter;
import org.qbicc.type.generic.TypeSignature;

public final class MethodSignature
extends ParameterizedSignature {
    private final List<TypeSignature> parameterTypes;
    private final TypeSignature returnTypeSignature;
    private final List<ThrowsSignature> throwsSignatures;
    public static final MethodSignature VOID_METHOD_SIGNATURE = new MethodSignature(List.of(), List.of(), BaseTypeSignature.V, List.of());

    MethodSignature(List<TypeParameter> typeParameters, List<TypeSignature> parameterTypes, TypeSignature returnTypeSignature, List<ThrowsSignature> throwsSignatures) {
        super(Objects.hash(MethodSignature.class, parameterTypes, returnTypeSignature, throwsSignatures), typeParameters);
        this.parameterTypes = parameterTypes;
        this.returnTypeSignature = returnTypeSignature;
        this.throwsSignatures = throwsSignatures;
    }

    public List<TypeSignature> getParameterTypes() {
        return this.parameterTypes;
    }

    public TypeSignature getReturnTypeSignature() {
        return this.returnTypeSignature;
    }

    public List<ThrowsSignature> getThrowsSignatures() {
        return this.throwsSignatures;
    }

    @Override
    public boolean equals(ParameterizedSignature other) {
        return other instanceof MethodSignature && this.equals((MethodSignature)other);
    }

    public boolean equals(MethodSignature other) {
        return super.equals(other) && this.parameterTypes.equals(other.parameterTypes) && this.returnTypeSignature.equals(other.returnTypeSignature) && this.throwsSignatures.equals(other.throwsSignatures);
    }

    public static MethodSignature parse(ClassContext classContext, ByteBuffer buf) {
        return (MethodSignature)ParameterizedSignature.parse(classContext, buf);
    }

    static MethodSignature parse(ClassContext classContext, ByteBuffer buf, List<TypeParameter> typeParameters) {
        List<ThrowsSignature> throwsSignatures;
        List<Object> parameterTypes;
        MethodSignature.expect(buf, 40);
        if (MethodSignature.peek(buf) != 41) {
            TypeSignature a = TypeSignature.parse(classContext, buf);
            if (MethodSignature.peek(buf) != 41) {
                TypeSignature b = TypeSignature.parse(classContext, buf);
                if (MethodSignature.peek(buf) != 41) {
                    TypeSignature c = TypeSignature.parse(classContext, buf);
                    if (MethodSignature.peek(buf) != 41) {
                        TypeSignature d = TypeSignature.parse(classContext, buf);
                        if (MethodSignature.peek(buf) != 41) {
                            TypeSignature e = TypeSignature.parse(classContext, buf);
                            if (MethodSignature.peek(buf) != 41) {
                                TypeSignature f = TypeSignature.parse(classContext, buf);
                                if (MethodSignature.peek(buf) != 41) {
                                    int i;
                                    parameterTypes = new ArrayList();
                                    Collections.addAll(parameterTypes, a, b, c, d, e, f);
                                    do {
                                        parameterTypes.add(TypeSignature.parse(classContext, buf));
                                    } while ((i = MethodSignature.peek(buf)) != 41);
                                    parameterTypes = List.copyOf(parameterTypes);
                                } else {
                                    parameterTypes = List.of(a, b, c, d, e, f);
                                }
                            } else {
                                parameterTypes = List.of(a, b, c, d, e);
                            }
                        } else {
                            parameterTypes = List.of(a, b, c, d);
                        }
                    } else {
                        parameterTypes = List.of(a, b, c);
                    }
                } else {
                    parameterTypes = List.of(a, b);
                }
            } else {
                parameterTypes = List.of(a);
            }
        } else {
            parameterTypes = List.of();
        }
        MethodSignature.expect(buf, 41);
        TypeSignature returnTypeSignature = TypeSignature.parse(classContext, buf);
        if (buf.hasRemaining()) {
            ThrowsSignature a = ThrowsSignature.parse(classContext, buf);
            if (buf.hasRemaining()) {
                ThrowsSignature b = ThrowsSignature.parse(classContext, buf);
                if (buf.hasRemaining()) {
                    ThrowsSignature c = ThrowsSignature.parse(classContext, buf);
                    if (buf.hasRemaining()) {
                        throwsSignatures = new ArrayList<ThrowsSignature>();
                        Collections.addAll(throwsSignatures, a, b, c);
                        do {
                            throwsSignatures.add(ThrowsSignature.parse(classContext, buf));
                        } while (buf.hasRemaining());
                        throwsSignatures = List.copyOf(throwsSignatures);
                    } else {
                        throwsSignatures = List.of(a, b, c);
                    }
                } else {
                    throwsSignatures = List.of(a, b);
                }
            } else {
                throwsSignatures = List.of(a);
            }
        } else {
            throwsSignatures = List.of();
        }
        return Cache.get(classContext).getMethodSignature(typeParameters, parameterTypes, returnTypeSignature, throwsSignatures);
    }

    public static MethodSignature synthesize(ClassContext classContext, MethodDescriptor methodDescriptor) {
        TypeSignature returnSig = TypeSignature.synthesize(classContext, methodDescriptor.getReturnType());
        List<TypeDescriptor> parameterTypes = methodDescriptor.getParameterTypes();
        int size = parameterTypes.size();
        TypeSignature[] argSigs = new TypeSignature[size];
        for (int i = 0; i < size; ++i) {
            argSigs[i] = TypeSignature.synthesize(classContext, parameterTypes.get(i));
        }
        return Cache.get(classContext).getMethodSignature(List.of(), Arrays.asList(argSigs), returnSig, List.of());
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        super.toString(target);
        target.append('(');
        for (TypeSignature p : this.parameterTypes) {
            p.toString(target);
        }
        target.append(')');
        this.returnTypeSignature.toString(target);
        for (ThrowsSignature t : this.throwsSignatures) {
            target.append('^');
            t.toString(target);
        }
        return target;
    }
}

