/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;

public final class TopLevelClassTypeSignature
extends ClassTypeSignature {
    private final String packageName;

    TopLevelClassTypeSignature(String packageName, String identifier, List<TypeArgument> typeArguments) {
        this(packageName, identifier, typeArguments, (ImmutableMap<ClassTypeDescriptor, Annotation>)Maps.immutable.empty());
    }

    TopLevelClassTypeSignature(String packageName, String identifier, List<TypeArgument> typeArguments, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        super(Objects.hash(TopLevelClassTypeSignature.class, packageName), identifier, typeArguments, annotations);
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean equals(ClassTypeSignature other) {
        return other instanceof TopLevelClassTypeSignature && this.equals((TopLevelClassTypeSignature)other);
    }

    public boolean equals(TopLevelClassTypeSignature other) {
        return super.equals(other) && this.packageName.equals(other.packageName);
    }

    @Override
    StringBuilder prefixString(StringBuilder target) {
        target.append('L');
        if (!this.packageName.isEmpty()) {
            target.append(this.packageName).append('/');
        }
        return this.simpleString(target);
    }

    @Override
    public TopLevelClassTypeSignature withAnnotation(Annotation annotation) {
        return (TopLevelClassTypeSignature)super.withAnnotation(annotation);
    }

    @Override
    public TopLevelClassTypeSignature withAnnotations(Set<Annotation> set) {
        return (TopLevelClassTypeSignature)super.withAnnotations(set);
    }

    @Override
    public TopLevelClassTypeSignature withOnlyAnnotations(Set<Annotation> set) {
        return (TopLevelClassTypeSignature)super.withOnlyAnnotations(set);
    }

    @Override
    public TopLevelClassTypeSignature withNoAnnotations() {
        return (TopLevelClassTypeSignature)super.withNoAnnotations();
    }

    @Override
    public TopLevelClassTypeSignature withoutAnnotation(Annotation annotation) {
        return (TopLevelClassTypeSignature)super.withoutAnnotation(annotation);
    }

    @Override
    public TopLevelClassTypeSignature withoutAnnotation(ClassTypeDescriptor descriptor) {
        return (TopLevelClassTypeSignature)super.withoutAnnotation(descriptor);
    }

    @Override
    TopLevelClassTypeSignature replacingAnnotationMap(ImmutableMap<ClassTypeDescriptor, Annotation> newMap) {
        return new TopLevelClassTypeSignature(this.packageName, this.getIdentifier(), this.getTypeArguments(), newMap);
    }

    @Override
    TypeDescriptor makeDescriptor(ClassContext classContext) {
        return ClassTypeDescriptor.synthesize(classContext, this.packageName + "/" + this.getIdentifier());
    }

    public static TopLevelClassTypeSignature parse(ClassContext classContext, ByteBuffer buf) {
        int lastIdx = -1;
        StringBuilder b = new StringBuilder();
        while (true) {
            int i;
            if ((i = TopLevelClassTypeSignature.peek(buf)) == 47) {
                buf.get();
                lastIdx = b.length();
                b.appendCodePoint(i);
                continue;
            }
            if (i == 46 || i == 59 || i == 60) {
                String identifier;
                String packageName;
                if (lastIdx == -1) {
                    packageName = "";
                    identifier = classContext.deduplicate(b.toString());
                } else {
                    packageName = classContext.deduplicate(b.substring(0, lastIdx));
                    identifier = classContext.deduplicate(b.substring(lastIdx + 1));
                }
                List<TypeArgument> typeArgs = i == 60 ? TypeArgument.parseList(classContext, buf) : List.of();
                return Cache.get(classContext).getTopLevelTypeSignature(packageName, identifier, typeArgs);
            }
            b.appendCodePoint(TopLevelClassTypeSignature.codePoint(buf));
        }
    }
}

