/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.methodhandle;

import io.smallrye.common.constraint.Assert;
import java.util.Objects;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodHandleConstant;
import org.qbicc.type.methodhandle.MethodHandleKind;

public final class FieldMethodHandleConstant
extends MethodHandleConstant {
    private final String fieldName;
    private final TypeDescriptor descriptor;

    public FieldMethodHandleConstant(ClassTypeDescriptor owner, String fieldName, MethodHandleKind kind, TypeDescriptor descriptor) {
        super(Objects.hash(fieldName, descriptor), owner, kind);
        if (!kind.isFieldTarget()) {
            throw new IllegalArgumentException("Field method handle cannot be of kind " + kind);
        }
        this.descriptor = (TypeDescriptor)Assert.checkNotNullParam((String)"descriptor", (Object)descriptor);
        this.fieldName = (String)Assert.checkNotNullParam((String)"fieldName", (Object)fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public TypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean equals(MethodHandleConstant other) {
        return other instanceof FieldMethodHandleConstant && this.equals((FieldMethodHandleConstant)other);
    }

    public boolean equals(FieldMethodHandleConstant other) {
        return super.equals(other) && this.fieldName.equals(other.fieldName) && this.descriptor.equals(other.descriptor);
    }

    public StringBuilder toString(StringBuilder target) {
        return target.append((Object)this.getKind()).append('[').append(this.getOwnerDescriptor()).append(':').append(this.fieldName).append(']');
    }
}

