/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.methodhandle;

import io.smallrye.common.constraint.Assert;
import java.util.Objects;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.Descriptor;
import org.qbicc.type.methodhandle.MethodHandleKind;

public abstract class MethodHandleConstant {
    private final ClassTypeDescriptor ownerDescriptor;
    private final MethodHandleKind kind;
    private final int hashCode;

    MethodHandleConstant(int hashCode, ClassTypeDescriptor ownerDescriptor, MethodHandleKind kind) {
        this.hashCode = Objects.hash(new Object[]{ownerDescriptor, kind}) * 19 + hashCode;
        this.ownerDescriptor = (ClassTypeDescriptor)Assert.checkNotNullParam((String)"ownerDescriptor", (Object)ownerDescriptor);
        this.kind = (MethodHandleKind)((Object)Assert.checkNotNullParam((String)"kind", (Object)((Object)kind)));
    }

    public abstract Descriptor getDescriptor();

    public final boolean equals(Object other) {
        return other instanceof MethodHandleConstant && this.equals((MethodHandleConstant)other);
    }

    public boolean equals(MethodHandleConstant other) {
        return this.ownerDescriptor.equals(other.ownerDescriptor) && this.kind.equals((Object)other.kind);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public ClassTypeDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    public MethodHandleKind getKind() {
        return this.kind;
    }
}

