/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.methodhandle;

public enum MethodHandleKind {
    GET_FIELD(1, Shape.FIELD, true),
    GET_STATIC(2, Shape.FIELD, false),
    PUT_FIELD(3, Shape.FIELD, true),
    PUT_STATIC(4, Shape.FIELD, false),
    INVOKE_VIRTUAL(5, Shape.METHOD, true),
    INVOKE_STATIC(6, Shape.METHOD, false),
    INVOKE_SPECIAL(7, Shape.METHOD, true),
    NEW_INVOKE_SPECIAL(8, Shape.CONSTRUCTOR, false),
    INVOKE_INTERFACE(9, Shape.METHOD, true);

    private final int id;
    private final Shape target;
    private final boolean instance;
    private static final MethodHandleKind[] values;

    private MethodHandleKind(int id, Shape target, boolean instance) {
        this.id = id;
        this.target = target;
        this.instance = instance;
    }

    public int getId() {
        return this.id;
    }

    public Shape getTarget() {
        return this.target;
    }

    public boolean isMethodTarget() {
        return this.getTarget() == Shape.METHOD;
    }

    public boolean isFieldTarget() {
        return this.getTarget() == Shape.FIELD;
    }

    public boolean isConstructorTarget() {
        return this.getTarget() == Shape.CONSTRUCTOR;
    }

    public boolean isInstance() {
        return this.instance;
    }

    public boolean isStatic() {
        return !this.isInstance();
    }

    public static MethodHandleKind forId(int id) {
        return values[id - 1];
    }

    public String toString() {
        return this.toString(new StringBuilder(21)).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        return b.append(this.name()).append('(').append(this.id).append(')');
    }

    static {
        values = MethodHandleKind.values();
    }

    public static enum Shape {
        FIELD,
        METHOD,
        CONSTRUCTOR;

    }
}

