/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.methodhandle;

import io.smallrye.common.constraint.Assert;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.methodhandle.ExecutableMethodHandleConstant;
import org.qbicc.type.methodhandle.MethodHandleKind;

public final class MethodMethodHandleConstant
extends ExecutableMethodHandleConstant {
    private final String methodName;

    public MethodMethodHandleConstant(ClassTypeDescriptor owner, String methodName, MethodHandleKind kind, MethodDescriptor descriptor) {
        super(methodName.hashCode(), owner, kind, descriptor);
        if (!kind.isMethodTarget()) {
            throw new IllegalArgumentException("Method method handle cannot be of kind " + kind);
        }
        this.methodName = (String)Assert.checkNotNullParam((String)"methodName", (Object)methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean equals(ExecutableMethodHandleConstant other) {
        return other instanceof MethodMethodHandleConstant && this.equals((MethodMethodHandleConstant)other);
    }

    public boolean equals(MethodMethodHandleConstant other) {
        return super.equals(other) && this.methodName.equals(other.methodName);
    }

    public StringBuilder toString(StringBuilder target) {
        return target.append((Object)this.getKind()).append('[').append(this.getOwnerDescriptor()).append('#').append(this.methodName).append(':').append(this.getDescriptor()).append(']');
    }
}

