/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.constraint.Assert;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.context.Location;
import org.qbicc.context.PhaseAttachmentKey;
import org.qbicc.graph.Node;
import org.qbicc.type.definition.element.Element;

public final class BaseDiagnosticContext
implements DiagnosticContext {
    final ConcurrentHashMap<AttachmentKey<?>, Object> attachmentsMap = new ConcurrentHashMap();
    volatile ConcurrentHashMap<PhaseAttachmentKey<?>, Object> phaseAttachmentsMap = new ConcurrentHashMap(0);
    volatile ConcurrentHashMap<PhaseAttachmentKey<?>, Object> prevPhaseAttachmentsMap = new ConcurrentHashMap();
    final ConcurrentLinkedDeque<Diagnostic> diagnostics = new ConcurrentLinkedDeque();
    final ConcurrentHashMap<String, String> stringCache = new ConcurrentHashMap();
    final AtomicInteger errorCnt = new AtomicInteger(0);
    final AtomicInteger warnCnt = new AtomicInteger(0);
    final int errorMax;
    final int warnMax;

    public BaseDiagnosticContext(int errorMax, int warnMax) {
        Assert.checkMinimumParameter((String)"errorMax", (int)1, (int)errorMax);
        Assert.checkMinimumParameter((String)"warnMax", (int)0, (int)warnMax);
        this.errorMax = errorMax;
        this.warnMax = warnMax;
    }

    public BaseDiagnosticContext() {
        this(100, 100);
    }

    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)this.attachmentsMap.get(key);
    }

    public <T> T getAttachmentOrDefault(AttachmentKey<T> key, T defVal) {
        return (T)this.attachmentsMap.getOrDefault(key, defVal);
    }

    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return (T)this.attachmentsMap.put(key, value);
    }

    public <T> T putAttachmentIfAbsent(AttachmentKey<T> key, T value) {
        return (T)this.attachmentsMap.putIfAbsent(key, value);
    }

    public <T> T removeAttachment(AttachmentKey<T> key) {
        return (T)this.attachmentsMap.remove(key);
    }

    public <T> boolean removeAttachment(AttachmentKey<T> key, T expect) {
        return this.attachmentsMap.remove(key, expect);
    }

    public <T> T replaceAttachment(AttachmentKey<T> key, T update) {
        return (T)this.attachmentsMap.replace(key, update);
    }

    public <T> boolean replaceAttachment(AttachmentKey<T> key, T expect, T update) {
        return this.attachmentsMap.replace(key, expect, update);
    }

    public <T> T computeAttachmentIfAbsent(AttachmentKey<T> key, Supplier<T> function) {
        return (T)this.attachmentsMap.computeIfAbsent(key, k -> function.get());
    }

    public <T> T computeAttachmentIfPresent(AttachmentKey<T> key, Function<T, T> function) {
        return (T)this.attachmentsMap.computeIfPresent(key, (k, v) -> function.apply(v));
    }

    public <T> T computeAttachment(AttachmentKey<T> key, Function<T, T> function) {
        return (T)this.attachmentsMap.compute(key, (k, v) -> function.apply(v));
    }

    public <T> T getAttachment(PhaseAttachmentKey<T> key) {
        return (T)this.phaseAttachmentsMap.get(key);
    }

    public <T> T getAttachmentOrDefault(PhaseAttachmentKey<T> key, T defVal) {
        return (T)this.phaseAttachmentsMap.getOrDefault(key, defVal);
    }

    public <T> T putAttachment(PhaseAttachmentKey<T> key, T value) {
        return (T)this.phaseAttachmentsMap.put(key, value);
    }

    public <T> T putAttachmentIfAbsent(PhaseAttachmentKey<T> key, T value) {
        return (T)this.phaseAttachmentsMap.putIfAbsent(key, value);
    }

    public <T> T removeAttachment(PhaseAttachmentKey<T> key) {
        return (T)this.phaseAttachmentsMap.remove(key);
    }

    public <T> boolean removeAttachment(PhaseAttachmentKey<T> key, T expect) {
        return this.phaseAttachmentsMap.remove(key, expect);
    }

    public <T> T replaceAttachment(PhaseAttachmentKey<T> key, T update) {
        return (T)this.phaseAttachmentsMap.replace(key, update);
    }

    public <T> boolean replaceAttachment(PhaseAttachmentKey<T> key, T expect, T update) {
        return this.phaseAttachmentsMap.replace(key, expect, update);
    }

    public <T> T computeAttachmentIfAbsent(PhaseAttachmentKey<T> key, Supplier<T> function) {
        return (T)this.phaseAttachmentsMap.computeIfAbsent(key, k -> function.get());
    }

    public <T> T computeAttachmentIfPresent(PhaseAttachmentKey<T> key, Function<T, T> function) {
        return (T)this.phaseAttachmentsMap.computeIfPresent(key, (k, v) -> function.apply(v));
    }

    public <T> T computeAttachment(PhaseAttachmentKey<T> key, Function<T, T> function) {
        return (T)this.phaseAttachmentsMap.compute(key, (k, v) -> function.apply(v));
    }

    public void cyclePhaseAttachments() {
        this.prevPhaseAttachmentsMap = this.phaseAttachmentsMap;
        this.phaseAttachmentsMap = new ConcurrentHashMap();
    }

    public <T> T getPreviousPhaseAttachment(PhaseAttachmentKey<T> key) {
        return (T)this.prevPhaseAttachmentsMap.get(key);
    }

    public int errors() {
        return this.errorCnt.get();
    }

    public int warnings() {
        return this.warnCnt.get();
    }

    Diagnostic msg(Diagnostic diagnostic) {
        if (diagnostic.getParent() == null) {
            int oldCnt;
            int max;
            AtomicInteger cnt;
            Diagnostic.Level level = diagnostic.getLevel();
            if (level == Diagnostic.Level.ERROR) {
                cnt = this.errorCnt;
                max = this.errorMax;
            } else if (level == Diagnostic.Level.WARNING) {
                cnt = this.warnCnt;
                max = this.warnMax;
            } else {
                this.diagnostics.addLast(diagnostic);
                return diagnostic;
            }
            do {
                if ((oldCnt = cnt.get()) != max) continue;
                return diagnostic;
            } while (!cnt.compareAndSet(oldCnt, oldCnt + 1));
            this.diagnostics.addLast(diagnostic);
        }
        return diagnostic;
    }

    public Diagnostic msg(Diagnostic parent, Location loc, Diagnostic.Level level, String fmt, Object ... args) {
        return this.msg(new Diagnostic(parent, loc, level, fmt, args));
    }

    public Diagnostic msg(Diagnostic parent, Element element, Node node, Diagnostic.Level level, String fmt, Object ... args) {
        Location loc;
        if (element == null && node == null) {
            loc = Location.NO_LOC;
        } else {
            Location.Builder lb = Location.builder();
            if (element != null) {
                lb.setElement(element);
            }
            if (node != null) {
                lb.setNode(node);
            }
            loc = lb.build();
        }
        return this.msg(parent, loc, level, fmt, args);
    }

    public Iterable<Diagnostic> getDiagnostics() {
        return Collections.unmodifiableCollection(this.diagnostics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String deduplicate(ByteBuffer buffer, int offset, int length) {
        byte[] array = new byte[length];
        int pos = buffer.position();
        buffer.position(offset);
        try {
            buffer.get(array);
            String string = this.deduplicate(new String(array));
            return string;
        }
        finally {
            buffer.position(pos);
        }
    }

    String deduplicate(String original) {
        return this.stringCache.computeIfAbsent(original, Function.identity());
    }
}

