/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import org.qbicc.context.ClassContext;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.definition.ResolutionFailedException;
import org.qbicc.type.definition.VerifyFailedException;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.ArrayTypeSignature;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

final class BasicDescriptorTypeResolver
implements DescriptorTypeResolver {
    private final ClassContext classContext;

    BasicDescriptorTypeResolver(ClassContext classContext) {
        this.classContext = classContext;
    }

    public ValueType resolveTypeFromClassName(String packageName, String internalName) {
        DefinedTypeDefinition definedType = this.classContext.findDefinedType((String)(packageName.isEmpty() ? internalName : packageName + "/" + internalName));
        if (definedType == null) {
            return this.classContext.getTypeSystem().getUnresolvedType();
        }
        try {
            return definedType.load().getObjectType();
        }
        catch (VerifyFailedException e) {
            return this.classContext.getTypeSystem().getUnresolvedType();
        }
    }

    public ValueType resolveTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        TypeSystem ts = this.classContext.getCompilationContext().getTypeSystem();
        if (descriptor instanceof BaseTypeDescriptor) {
            switch (((BaseTypeDescriptor)descriptor).getShortName()) {
                case 'B': {
                    return ts.getSignedInteger8Type();
                }
                case 'C': {
                    return ts.getUnsignedInteger16Type();
                }
                case 'D': {
                    return ts.getFloat64Type();
                }
                case 'F': {
                    return ts.getFloat32Type();
                }
                case 'I': {
                    return ts.getSignedInteger32Type();
                }
                case 'J': {
                    return ts.getSignedInteger64Type();
                }
                case 'S': {
                    return ts.getSignedInteger16Type();
                }
                case 'V': {
                    return ts.getVoidType();
                }
                case 'Z': {
                    return ts.getBooleanType();
                }
            }
            throw new ResolutionFailedException("Cannot resolve type " + descriptor);
        }
        if (descriptor instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor classTypeDescriptor = (ClassTypeDescriptor)descriptor;
            return this.classContext.resolveTypeFromClassName(classTypeDescriptor.getPackageName(), classTypeDescriptor.getClassName());
        }
        assert (descriptor instanceof ArrayTypeDescriptor);
        ArrayObjectType arrayObjectType = this.resolveArrayObjectTypeFromDescriptor(descriptor, paramCtxt, signature);
        return arrayObjectType;
    }

    public ArrayObjectType resolveArrayObjectTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        if (descriptor instanceof BaseTypeDescriptor) {
            throw new ResolutionFailedException("Cannot resolve type as array " + descriptor);
        }
        if (descriptor instanceof ClassTypeDescriptor) {
            throw new ResolutionFailedException("Cannot resolve type as array " + descriptor);
        }
        assert (descriptor instanceof ArrayTypeDescriptor);
        TypeDescriptor elemDescriptor = ((ArrayTypeDescriptor)descriptor).getElementTypeDescriptor();
        TypeSystem ts = this.classContext.getTypeSystem();
        if (elemDescriptor instanceof BaseTypeDescriptor) {
            switch (((BaseTypeDescriptor)elemDescriptor).getShortName()) {
                case 'B': {
                    return ts.getSignedInteger8Type().getPrimitiveArrayObjectType();
                }
                case 'C': {
                    return ts.getUnsignedInteger16Type().getPrimitiveArrayObjectType();
                }
                case 'D': {
                    return ts.getFloat64Type().getPrimitiveArrayObjectType();
                }
                case 'F': {
                    return ts.getFloat32Type().getPrimitiveArrayObjectType();
                }
                case 'I': {
                    return ts.getSignedInteger32Type().getPrimitiveArrayObjectType();
                }
                case 'J': {
                    return ts.getSignedInteger64Type().getPrimitiveArrayObjectType();
                }
                case 'S': {
                    return ts.getSignedInteger16Type().getPrimitiveArrayObjectType();
                }
                case 'Z': {
                    return ts.getBooleanType().getPrimitiveArrayObjectType();
                }
            }
            throw new ResolutionFailedException("Cannot resolve type as array " + descriptor);
        }
        if (elemDescriptor instanceof ClassTypeDescriptor) {
            ValueType elemType = this.classContext.resolveTypeFromClassName(((ClassTypeDescriptor)elemDescriptor).getPackageName(), ((ClassTypeDescriptor)elemDescriptor).getClassName());
            if (elemType instanceof ObjectType) {
                return ((ObjectType)elemType).getReferenceArrayObject();
            }
            throw new ResolutionFailedException("Cannot resolve type as array " + descriptor);
        }
        TypeSignature elemSig = signature instanceof ArrayTypeSignature ? ((ArrayTypeSignature)signature).getElementTypeSignature() : TypeSignature.synthesize((ClassContext)this.classContext, (TypeDescriptor)elemDescriptor);
        ArrayObjectType elementArrayObj = this.resolveArrayObjectTypeFromDescriptor(elemDescriptor, paramCtxt, elemSig);
        return elementArrayObj.getReferenceArrayObject();
    }

    public ValueType resolveTypeFromMethodDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        return this.classContext.resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
    }
}

