/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.BasicDescriptorTypeResolver;
import org.qbicc.driver.CompilationContextImpl;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefineFailedException;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.definition.MethodTypeId;
import org.qbicc.type.definition.TypeId;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

final class ClassContextImpl
implements ClassContext {
    private final CompilationContextImpl compilationContext;
    private final VmClassLoader classLoader;
    private final DescriptorTypeResolver descriptorTypeResolver;
    private final ConcurrentMap<String, AtomicReference<Object>> definedClasses = new ConcurrentHashMap<String, AtomicReference<Object>>();
    private final BiFunction<ClassContext, String, DefinedTypeDefinition> finder;
    private final BiFunction<ClassContext, String, byte[]> resourceFinder;
    private final BiFunction<ClassContext, String, List<byte[]>> resourcesFinder;
    private static final Object LOADING = new Object();
    private static final Object NOT_FOUND = new Object();

    ClassContextImpl(CompilationContextImpl compilationContext, VmClassLoader classLoader, BiFunction<ClassContext, String, DefinedTypeDefinition> finder, BiFunction<ClassContext, String, byte[]> resourceFinder, BiFunction<ClassContext, String, List<byte[]>> resourcesFinder) {
        this.compilationContext = compilationContext;
        this.classLoader = classLoader;
        this.finder = finder;
        this.resourceFinder = resourceFinder;
        this.resourcesFinder = resourcesFinder;
        BasicDescriptorTypeResolver descriptorTypeResolver = new BasicDescriptorTypeResolver(this);
        for (BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver> factory : compilationContext.resolverFactories) {
            descriptorTypeResolver = factory.apply(this, descriptorTypeResolver);
        }
        this.descriptorTypeResolver = descriptorTypeResolver;
    }

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }

    public VmClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefinedTypeDefinition findDefinedType(String typeName) {
        AtomicReference<Object> ref = (AtomicReference<Object>)this.definedClasses.get(typeName);
        while (true) {
            AtomicReference<Object> atomicReference;
            if (ref != null) {
                Object val = ref.get();
                if (val == LOADING) {
                    atomicReference = ref;
                    synchronized (atomicReference) {
                        val = ref.get();
                    }
                }
                if (val == NOT_FOUND) {
                    return null;
                }
                DefinedTypeDefinition definedTypeDefinition = (DefinedTypeDefinition)val;
                return definedTypeDefinition;
            }
            atomicReference = ref = new AtomicReference<Object>(LOADING);
            synchronized (atomicReference) {
                AtomicReference<Object> appearing = this.definedClasses.putIfAbsent(typeName, ref);
                if (appearing == null) break;
                ref = appearing;
            }
        }
        {
            DefinedTypeDefinition definition = this.finder.apply(this, typeName);
            ref.set(definition == null ? NOT_FOUND : definition);
            return definition;
        }
    }

    public byte[] getResource(String resourceName) {
        return this.resourceFinder.apply(this, resourceName);
    }

    public List<byte[]> getResources(String resourceName) {
        return this.resourcesFinder.apply(this, resourceName);
    }

    public boolean isBootstrap() {
        return this == this.compilationContext.getBootstrapClassContext();
    }

    public String deduplicate(ByteBuffer buffer, int offset, int length) {
        return this.compilationContext.deduplicate(buffer, offset, length);
    }

    public String deduplicate(String original) {
        return this.compilationContext.deduplicate(original);
    }

    public MethodTypeId resolveMethodType(MethodDescriptor descriptor) {
        List<TypeId> paramTypeIds;
        TypeId returnTypeId = this.resolveDescriptor(descriptor.getReturnType());
        if (returnTypeId == null) {
            return null;
        }
        List mdParamTypes = descriptor.getParameterTypes();
        if (mdParamTypes.isEmpty()) {
            paramTypeIds = List.of();
        } else {
            int size = mdParamTypes.size();
            TypeId[] paramTypesArray = new TypeId[size];
            for (int i = 0; i < size; ++i) {
                TypeDescriptor ptd = (TypeDescriptor)mdParamTypes.get(i);
                TypeId pt = this.resolveDescriptor(ptd);
                if (pt == null) {
                    return null;
                }
                paramTypesArray[i] = pt;
            }
            paramTypeIds = Arrays.asList(paramTypesArray);
        }
        return this.compilationContext.getMethodType(returnTypeId, paramTypeIds, descriptor);
    }

    public TypeSystem getTypeSystem() {
        return this.compilationContext.getTypeSystem();
    }

    public LiteralFactory getLiteralFactory() {
        return this.compilationContext.getLiteralFactory();
    }

    public BasicBlockBuilder newBasicBlockBuilder(BasicBlockBuilder.FactoryContext factoryContext, ExecutableElement element) {
        return this.compilationContext.getBlockFactory().apply(factoryContext, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineClass(String name, DefinedTypeDefinition definition) {
        AtomicReference<DefinedTypeDefinition> ref = (AtomicReference<DefinedTypeDefinition>)this.definedClasses.get(name);
        if (ref == null) {
            ref = new AtomicReference<DefinedTypeDefinition>(definition);
            if ((ref = this.definedClasses.putIfAbsent(name, ref)) == null) {
                return;
            }
        }
        if (Thread.holdsLock(ref)) {
            assert (ref.get() == LOADING);
            return;
        }
        if (ref.get() == NOT_FOUND) {
            AtomicReference<DefinedTypeDefinition> atomicReference = ref;
            synchronized (atomicReference) {
                if (ref.compareAndSet((DefinedTypeDefinition)NOT_FOUND, definition)) {
                    return;
                }
            }
        }
        throw new DefineFailedException("Duplicated class named " + name);
    }

    public ValueType resolveTypeFromClassName(String packageName, String internalName) {
        return this.descriptorTypeResolver.resolveTypeFromClassName(packageName, internalName);
    }

    public ValueType resolveTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        return this.descriptorTypeResolver.resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
    }

    public ArrayObjectType resolveArrayObjectTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        return this.descriptorTypeResolver.resolveArrayObjectTypeFromDescriptor(descriptor, paramCtxt, signature);
    }

    public DefinedTypeDefinition.Builder newTypeBuilder() {
        DefinedTypeDefinition.Builder builder = DefinedTypeDefinition.Builder.basic();
        for (BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder> factory : this.compilationContext.getTypeBuilderFactories()) {
            builder = factory.apply(this, builder);
        }
        return builder;
    }

    public ValueType resolveTypeFromMethodDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        return this.descriptorTypeResolver.resolveTypeFromMethodDescriptor(descriptor, paramCtxt, signature);
    }
}

